/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.QueryDialog;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.FastFetch;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;

public class QueryDrillDownAction
extends Action {
    private QueryVO query;
    private LoggingEventVO event;
    private String attribute;
    private String matchText;
    private static int drillCount = 1;

    public QueryDrillDownAction(LoggingEventVO event, TimeRange range, TimeZone timeZone) {
        this.event = event;
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText(range.toString());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
        this.query = new QueryVO("drill", -1, range.getTime(true, event.getLoggerTimeStamp()), range.getTime(false, event.getLoggerTimeStamp()));
        this.query.setTimeZone(timeZone);
        JexlCriteria criteria = new JexlCriteria();
        Rule rule = criteria.addRule();
        rule.addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.is, (Object)event.getLoggerLevel());
        rule.addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)event.getDomainName());
        rule.addCondition((Object)EventAttribute.hostName, (Object)Operation.is, (Object)event.getHostName());
        rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.is, (Object)event.getLoggerName());
        rule.addCondition((Object)EventAttribute.message, (Object)Operation.contains, (Object)event.getMessage());
        this.query.setCriteria((CriteriaFilter)criteria);
    }

    public QueryDrillDownAction(LoggingEventVO event, String attribute, TimeRange range, TimeZone timeZone, String matchText) {
        this(event, attribute, range, timeZone, false, matchText);
    }

    public QueryDrillDownAction(LoggingEventVO event, String attribute, TimeRange range, TimeZone timeZone, boolean useCurrentTime, String matchText) {
        this.event = event;
        this.attribute = attribute;
        this.matchText = matchText;
        this.setId(((Object)((Object)this)).getClass().getName());
        long timeRef = useCurrentTime ? System.currentTimeMillis() : event.getLoggerTimeStamp();
        this.query = range != null ? new QueryVO("drill", -1, range.getTime(true, timeRef), range.getTime(false, timeRef)) : new QueryVO("custom");
        this.query.setTimeZone(timeZone);
        JexlCriteria criteria = new JexlCriteria();
        Rule rule = criteria.addRule();
        this.query.setCriteria((CriteriaFilter)criteria);
        if (attribute == null) {
            this.setText("match everything...");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/feed.gif"));
            rule.addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.TRACE.name());
            return;
        }
        switch (EventAttribute.fromString((String)attribute)) {
            case domainName: {
                this.setText(String.format("where domain is '%s'", event.getDomainName()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/domain.gif"));
                rule.addCondition((Object)attribute, (Object)Operation.is, (Object)event.getDomainName());
                break;
            }
            case hostName: {
                this.setText(String.format("where host is '%s'", event.getHostName()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/host.gif"));
                rule.addCondition((Object)attribute, (Object)Operation.is, (Object)event.getHostName());
                break;
            }
            case loggerName: {
                this.setText(String.format("where logger is '%s'", event.getLoggerNameShort()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
                rule.addCondition((Object)attribute, (Object)Operation.is, (Object)event.getLoggerName());
                break;
            }
            case threadName: {
                this.setText(String.format("where thread is '%s'", event.getThreadName()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/trace_start.gif"));
                rule.addCondition((Object)attribute, (Object)Operation.is, (Object)event.getThreadName());
                break;
            }
            case message: {
                String text = StringUtils.isBlank((CharSequence)matchText) ? event.getMessage() : matchText;
                this.setText(String.format("where message contains '%s'", StringUtils.abbreviate((String)text, (int)16)));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/textfield.gif"));
                if (StringUtils.isBlank((CharSequence)matchText)) break;
                rule.addCondition((Object)attribute, (Object)Operation.contains, (Object)text);
                break;
            }
            case throwableInfo: {
                String text = StringUtils.isBlank((CharSequence)matchText) ? event.getExceptionClass() : matchText;
                this.setText(String.format("where exception is '%s'", StringUtils.abbreviate((String)text, (int)32)));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/textfield.gif"));
                rule.addCondition((Object)EventAttribute.thrown, (Object)Operation.is, (Object)Boolean.TRUE);
                rule.addCondition((Object)attribute, (Object)Operation.contains, (Object)text);
                break;
            }
            case mdc: {
                String value = event.getProperty(attribute);
                this.setText(String.format("where %s is '%s", attribute, value));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/prop_ps.gif"));
                rule.addCondition((Object)attribute, (Object)Operation.is, (Object)value);
                break;
            }
        }
    }

    public QueryDrillDownAction(LoggingEventVO event, ComponentModel component, TagVO tag, TimeRange range, TimeZone timeZone) {
        this.event = event;
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText(range.toString());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
        this.query = new QueryVO("drill", -1, range.getTime(true, event.getLoggerTimeStamp()), range.getTime(false, event.getLoggerTimeStamp()));
        this.query.setTimeZone(timeZone);
        JexlCriteria criteria = new JexlCriteria();
        if (component != null) {
            String[] stringArray = component.getPackageNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pack = stringArray[n2];
                criteria.addRule().addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack);
                ++n2;
            }
        } else if (tag != null) {
            criteria = tag.getCriteria();
        }
        this.query.setCriteria((CriteriaFilter)criteria);
    }

    public void run() {
        QueryDialog dialog;
        if ("custom".equals(this.query.getName())) {
            dialog = new QueryDialog(Application.getShell(), this.query, false);
            if (dialog.open() != 0) {
                return;
            }
            FastFetch.getInstance().setQuery(this.query);
        } else if (EventAttribute.message.name().equals(this.attribute) && StringUtils.isBlank((CharSequence)this.matchText)) {
            dialog = new InputDialog(null, "Input", "Match message text", this.event.getMessage(), null);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return;
            }
            this.matchText = dialog.getValue();
            Rule rule = (Rule)this.query.getCriteria().getRules().get(0);
            rule.addCondition((Object)this.attribute, (Object)Operation.contains, (Object)this.matchText);
        }
        this.query.setName("Drill-" + drillCount++);
        this.query.setHeaders((LogHeaderInfoVO[])Utils.getContextVariable("headers"));
        FetchQueryRapidJob job = new FetchQueryRapidJob(new QueryDataFetcher(this.query, (LogEvent)this.event, true));
        job.setUser(true);
        job.schedule();
    }
}

