/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.SyncPluginsJob;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import java.io.File;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PluginsAction
extends Action {
    private static final Logger log = LogManager.getLogger(PluginsAction.class);

    public PluginsAction() {
        if (Compatibility.canUsePlugins()) {
            this.setText("Synchronize extension plugins");
            this.setToolTipText("Downloads and installs extension plugins");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/plugin.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        } else {
            this.setText("Add extension plugin");
            this.setToolTipText("Add extension plugin");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/plugin.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }
    }

    public void run() {
        if (Compatibility.canUsePlugins()) {
            SyncPluginsJob job = new SyncPluginsJob();
            job.setUser(true);
            job.schedule();
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), 4098);
        dialog.setText("Select plugin files");
        dialog.setFilterExtensions(new String[]{"*.*"});
        dialog.setFilterNames(new String[]{"All files (*.*)"});
        if (dialog.open() == null) {
            return;
        }
        try {
            ArrayList files = Lists.newArrayList();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                files.add(new File(String.format("%s%s%s", dialog.getFilterPath(), File.separator, name)));
                ++n2;
            }
            LogFacesPlugin plugin = PluginsDelegate.getInstance().addPlugin(files);
            Utils.displayPopup("Done", String.format("Plugin added to workspace and ready for use%n%s", plugin.getName()), false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Utils.displayException("Failed", e.getMessage(), e);
        }
    }
}

