/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.PluginsAction;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.actions.ActionFactory;

public class PinAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final Logger log = LogManager.getLogger(PluginsAction.class);
    private LogView view;
    private QueryVO query;

    public PinAction(LogView view) {
        this.view = view;
        this.setText("Pin visible items for sharing");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/flag.png"));
    }

    public void run() {
        try {
            this.query = this.view.createPin();
            String name = String.format("pin%d: %s", 1 + QueryModel.getInstance().getNofPins(), this.query.getName());
            InputDialog dialog = new InputDialog(null, "Create pin", "Pin name (for display purposes)", name, null);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return;
            }
            this.query.setName(dialog.getValue());
            LfsConnector connector = LfsConnector.getInstance();
            connector.getConnection().addPin(connector.getSid(), this.query.getPinID(), this.query.toXml());
            QueryModel.getInstance().addQuery(this.query);
            log.info("created pin '{}' with {} events, selected {}", (Object)this.query.getName());
            Utils.displayOneTimeTip("tip_first_pin", "These events are now shared with other users of this server instance.\nAsk them to look in 'My Queries' view to display the content.\n\n(this message will not appear again)");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void dispose() {
    }
}

