/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.FetchQueryJob;
import com.moonlit.logfaces.client.jobs.LogFileParser;
import com.moonlit.logfaces.client.model.ParserVO;
import com.moonlit.logfaces.client.model.ParsersModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class ParseLogFileAction
extends Action
implements IMenuCreator,
IEclipsePreferences.IPreferenceChangeListener {
    private Menu fMenu;
    private List<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
    private static final Logger log = LogManager.getLogger(ParseLogFileAction.class);

    public ParseLogFileAction() {
        super("Open log file using this parser...", 4);
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setMenuCreator(this);
        LfsEventBus.getInstance().register((Object)this);
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.WORKSPACE_LOADED)) {
            this.setEnabled(ParsersModel.getInstance().size() > 0);
            this.repopulate();
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("lfs_parsers".equals(key)) {
            this.setEnabled(ParsersModel.getInstance().size() > 0);
            this.repopulate();
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        this.fMenu = new Menu(parent);
        for (ParserVO parser : ParsersModel.getInstance().getParsers()) {
            ActionContributionItem item = new ActionContributionItem((IAction)new OpenFileAction(parser));
            item.fill(this.fMenu, -1);
            this.items.add(item);
        }
        return this.fMenu;
    }

    private void repopulate() {
        for (ActionContributionItem item : this.items) {
            item.dispose();
        }
        for (ParserVO parser : ParsersModel.getInstance().getParsers()) {
            ActionContributionItem item = new ActionContributionItem((IAction)new OpenFileAction(parser));
            item.fill(this.fMenu, -1);
            this.items.add(item);
        }
    }

    public void dispose() {
        this.fMenu.dispose();
    }

    public void run() {
    }

    private File ensurePatternsLibrary() throws Exception {
        File file = new File(String.format("%s%spatterns.properties", Platform.getConfigurationLocation().getURL().getPath(), File.separator));
        if (file.exists()) {
            return file;
        }
        if (Application.isServerMode()) {
            throw new Exception("No local pattern library found");
        }
        if (!LfsConnector.getInstance().isConnected()) {
            throw new Exception("No local pattern library and can't obtain one from server");
        }
        try {
            LfsConnector connector = LfsConnector.getInstance();
            InputStream is = connector.getConnection().getPatternLibrary(connector.getSid());
            FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Unable to download pattern library from server");
        }
        return file;
    }

    class OpenFileAction
    extends Action {
        private ParserVO parser;

        public OpenFileAction(ParserVO parser) {
            this.parser = parser;
            this.setText(parser.getName());
            this.setToolTipText("Parse and open text log file");
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/dashboard.gif"));
        }

        public void run() {
            try {
                ParseLogFileAction.this.ensurePatternsLibrary();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Application.getShell(), (String)"Pattern library", (String)e.getMessage());
                return;
            }
            FileDialog dialog = new FileDialog(Application.getShell(), 4098);
            dialog.setText("Log file name");
            dialog.setFilterExtensions(new String[]{"*.log", "*.*"});
            dialog.setFilterNames(new String[]{"log files (*.log)", "All files (*.*)"});
            if (dialog.open() == null) {
                return;
            }
            String path = dialog.getFilterPath();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(String.format("%s%s%s", path, File.separator, fileName));
                log.info("parsing {}", (Object)file);
                LogFileParser fetcher = new LogFileParser(file, this.parser);
                FetchQueryJob job = new FetchQueryJob(fetcher);
                job.setUser(true);
                job.schedule();
                ++n2;
            }
        }
    }
}

