/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class OpenLogPerspectiveAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private PerspectiveVO perspetive;

    public OpenLogPerspectiveAction(String name) {
        this(LogPerspectivesModel.getInstance().getPerspective(name));
    }

    public OpenLogPerspectiveAction(PerspectiveVO p) {
        this.perspetive = p;
        if (this.perspetive == null) {
            return;
        }
        this.setText(this.perspetive.getName());
        this.setToolTipText("Activate selected log perspectives");
        this.setId(((Object)((Object)this)).getClass().getName());
        boolean parametrized = Utils.isParametrized(this.perspetive.getCriteria());
        this.setImageDescriptor(MainPlugin.getImageDescriptor(parametrized ? "icons/filter-red.gif" : "icons/filter.gif"));
    }

    public void run() {
        if (this.perspetive == null) {
            return;
        }
        if (LfsConnector.getInstance().getConnection() == null) {
            Utils.displayPopup("Error", "Not connected to server", true);
            return;
        }
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            LogEditorInput input = new LogEditorInput(this.perspetive);
            Map<String, String> params = Utils.parameterizeCriteria(input.getRtCriteria());
            if (params == null) {
                return;
            }
            input.setParams(params);
            page.openEditor((IEditorInput)input, "com.moonlit.logfaces.client.LogEditor");
        }
        catch (Exception e) {
            Utils.displayPopup("Error", "Error opening view:" + e.getMessage(), true);
        }
    }

    public void dispose() {
    }
}

