/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.NewWorkspaceDialog;
import com.moonlit.logfaces.client.net.LfsConnector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewWorkspaceAction
extends Action {
    public NewWorkspaceAction() {
        this.setText("New workspace");
        this.setToolTipText("Create new workspace");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            Shell shell = window.getShell();
            try {
                WorkspaceHolder wsh = WorkspaceHolder.getInstance();
                NewWorkspaceDialog dialog = new NewWorkspaceDialog(shell);
                if (dialog.open() != 0) {
                    return;
                }
                wsh.createNew(dialog.getName(), dialog.getHost(), dialog.getPort(), dialog.getUser(), dialog.getPassword(), dialog.isSsl(), dialog.isCopy());
                window.getActivePage().closeAllEditors(true);
                LfsConnector.getInstance().terminate();
                wsh.switchTo(dialog.getName());
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)shell, (String)"Failed", (String)ex.getMessage());
            }
        }
    }
}

