/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.net.LfsConnector;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class LoadSharedWorkspaceAction
extends Action {
    public LoadSharedWorkspaceAction() {
        this.setText("Import workspace from server");
        this.setToolTipText("Lets selecting and loading server shared workspace");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_import.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        LfsConnector connector = LfsConnector.getInstance();
        if (!connector.isConnected()) {
            MessageDialog.openError((Shell)window.getShell(), (String)"No connection", (String)"Unable to list shared workspaces because there is no connection to logFaces server");
            return;
        }
        if (window != null) {
            try {
                connector = LfsConnector.getInstance();
                List list = connector.getConnection().listWorkspaces(connector.getSid());
                if (list.isEmpty()) {
                    MessageDialog.openInformation((Shell)window.getShell(), (String)"Nothing to import", (String)"This server doesn't have any shared workspaces.");
                    return;
                }
                ListDialog dlg = new ListDialog(window.getShell());
                dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dlg.setInitialSelections(new Object[]{list.get(0)});
                dlg.setLabelProvider((ILabelProvider)new LabelProvider());
                dlg.setInput((Object)list);
                dlg.setTitle("Server shared workspaces");
                dlg.setMessage(String.format("Those are workspaces shared on server %s,\nselect one to import into your environment", ConnectionProfile.getInstance().getServerHost()));
                if (dlg.open() != 0) {
                    return;
                }
                String name = (String)dlg.getResult()[0];
                InputStream is = connector.getConnection().downloadWorkspace(connector.getSid(), name);
                window.getActivePage().closeAllEditors(true);
                LfsConnector.getInstance().terminate();
                WorkspaceHolder.getInstance().importNew(name, is);
            }
            catch (UndeclaredThrowableException e) {
                MessageDialog.openError((Shell)window.getShell(), (String)"Not supported", (String)"This server version doesn't support shared workspaces.\nConsider upgrading.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Throwable cause = ex.getCause();
                MessageDialog.openError((Shell)window.getShell(), (String)"Import failed", (String)(cause != null ? cause.getMessage() : ex.getMessage()));
            }
        }
    }
}

