/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ShowComponentsAction;
import com.moonlit.logfaces.client.actions.ShowHostsAction;
import com.moonlit.logfaces.client.actions.ShowRepositoryAction;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ListRepositoryAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private List<Action> actions = Lists.newArrayList();

    public ListRepositoryAction() {
        this.setText("Context");
        this.setToolTipText("Auxilary context views");
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/domain.gif"));
        this.setMenuCreator(this);
        this.actions.add(new ShowRepositoryAction());
        this.actions.add(new ShowHostsAction());
        this.actions.add(new ShowComponentsAction());
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        for (Action action : this.actions) {
            this.addActionToMenu(action);
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
    }

    protected void addActionToMenu(Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(this.fMenu, -1);
    }

    public void runWithEvent(Event e) {
        Widget item = e.widget;
        ToolItem ti = (ToolItem)item;
        Menu m = this.getMenu((Control)ti.getParent());
        if (m != null) {
            Rectangle rect = ti.getBounds();
            Point point = ti.getParent().toDisplay(new Point(rect.x, rect.y));
            m.setLocation(point.x, point.y + ti.getParent().getBounds().height);
            m.setVisible(true);
            return;
        }
        new ShowRepositoryAction().run();
    }
}

