/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.QueryDialog;
import com.moonlit.logfaces.client.editors.DashboardEditor;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class ListQueriesAction
extends Action
implements IMenuCreator {
    private Menu fMenu;

    public ListQueriesAction() {
        this.setText("Queries");
        this.setToolTipText("Show query editor");
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/database.gif"));
        this.setMenuCreator(this);
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.addActionToMenu(new AddQueryAction());
        new MenuItem(this.fMenu, 2);
        ContextElement[] elements = QueryModel.getInstance().getEntries();
        int i = 0;
        while (i < elements.length) {
            this.addActionToMenu(new QueryAction((QueryVO)elements[i]));
            ++i;
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.addActionToMenu(new AddQueryAction());
        new MenuItem(this.fMenu, 2);
        ContextElement[] elements = QueryModel.getInstance().getEntries();
        int i = 0;
        while (i < elements.length) {
            this.addActionToMenu(new QueryAction((QueryVO)elements[i]));
            ++i;
        }
        return this.fMenu;
    }

    public void dispose() {
    }

    protected void addActionToMenu(Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(this.fMenu, -1);
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                IEditorPart activeEditor = window.getActivePage().getActiveEditor();
                if (activeEditor != null && activeEditor instanceof DashboardEditor) {
                    return;
                }
                IViewPart view = window.getActivePage().findView("com.moonlit.logfaces.client.DBQ");
                if (view == null) {
                    window.getActivePage().showView("com.moonlit.logfaces.client.DBQ");
                } else {
                    window.getActivePage().hideView(view);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Unable to open editor: " + e.getMessage()));
            }
        }
    }

    class AddQueryAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        AddQueryAction() {
            this.setText("Create new query");
            this.setToolTipText("Create new re-usable query");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            int counter = PersistentCounter.getInstance().getCounter();
            QueryVO query = new QueryVO("Query-" + counter);
            query.setTimeRange(TimeRange.BEFORE_1_HOUR, 0L, 0L);
            query.setTimeZone(TimeZone.getDefault());
            QueryModel queryModel = QueryModel.getInstance();
            JexlCriteria criteria = new JexlCriteria();
            criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.WARN.name());
            query.setCriteria((CriteriaFilter)criteria);
            QueryDialog dialog = new QueryDialog(Application.getShell(), query, true);
            switch (dialog.open()) {
                case 1: {
                    return;
                }
                case 0: {
                    queryModel.addQuery(query);
                    new QueryAction(query).run();
                    break;
                }
                default: {
                    queryModel.addQuery(query);
                }
            }
        }

        public void dispose() {
        }
    }

    class QueryAction
    extends Action {
        private final QueryVO query;

        public QueryAction(QueryVO query) {
            this.query = query;
            this.setText(query.getName());
            this.setId(((Object)((Object)this)).getClass().getName());
            if (Utils.isParametrized(query.getCriteria())) {
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/query-red.gif"));
            } else if (query.isPin()) {
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/flag.png"));
            } else {
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/query.gif"));
            }
        }

        public void run() {
            QueryDataFetcher fetcher = new QueryDataFetcher(this.query, true);
            FetchQueryRapidJob job = new FetchQueryRapidJob(fetcher);
            job.setUser(true);
            job.schedule();
        }
    }
}

