/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.OpenLogPerspectiveAction;
import com.moonlit.logfaces.client.dialogs.LogPerspectiveDlg;
import com.moonlit.logfaces.client.editors.DashboardEditor;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ListPerspectivesAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private static final Logger log = LogManager.getLogger(ListPerspectivesAction.class);

    public ListPerspectivesAction() {
        this.setText("Perspectives");
        this.setToolTipText("Shows my perspectives");
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/filter.gif"));
        this.setMenuCreator(this);
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.addActionToMenu(new AddPerspectiveAction());
        new MenuItem(this.fMenu, 2);
        ContextElement[] elements = LogPerspectivesModel.getInstance().getEntries();
        int i = 0;
        while (i < elements.length) {
            this.addActionToMenu(new OpenLogPerspectiveAction(elements[i].getName()));
            ++i;
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
    }

    protected void addActionToMenu(Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(this.fMenu, -1);
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        try {
            IEditorPart activeEditor = window.getActivePage().getActiveEditor();
            if (activeEditor != null && activeEditor instanceof DashboardEditor) {
                return;
            }
            IViewPart view = window.getActivePage().findView("com.moonlit.logfaces.client.WorkspaceView");
            if (view == null) {
                window.getActivePage().showView("com.moonlit.logfaces.client.WorkspaceView");
            } else {
                window.getActivePage().hideView(view);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Unable to open editor: " + e.getMessage()));
        }
    }

    class AddPerspectiveAction
    extends Action {
        public AddPerspectiveAction() {
            this.setText("Create new perspective");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            PerspectiveVO vo = new PerspectiveVO();
            JexlCriteria criteria = new JexlCriteria();
            criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.TRACE.name());
            vo.setCriteria((CriteriaFilter)criteria);
            vo.setName("New perspective (" + PersistentCounter.getInstance().getCounter() + ")");
            vo.setActivated(true);
            LogPerspectiveDlg dialog = new LogPerspectiveDlg(Application.getShell(), vo);
            if (dialog.open() == 0) {
                LogPerspectivesModel.getInstance().addPerspective(vo);
                new OpenLogPerspectiveAction(vo).run();
                return;
            }
        }
    }
}

