/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dashboard.Dashboard;
import com.moonlit.logfaces.client.dashboard.DashboardsModel;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.editors.DashboardEditor;
import com.moonlit.logfaces.client.editors.DashboardEditorInput;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ListDashboardsAction
extends Action
implements IMenuCreator {
    private Menu menu;
    private DashboardsModel dashboards = DashboardsModel.getInstance();

    public ListDashboardsAction() {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/dashboard.gif"));
        this.setMenuCreator(this);
        boolean enabled = Compatibility.canUseDashboards();
        this.setText("Dashboards");
        this.setToolTipText(enabled ? "Show dashboard view" : "This server version doesn't support Dashboards\nMinimum server requirement for Dashboards is v4.2.0");
        this.setEnabled(enabled);
    }

    public Menu getMenu(Control parent) {
        if (this.dashboards.isEmpty()) {
            return null;
        }
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        for (Dashboard dashboard : this.dashboards.getDashboards()) {
            ShowDashboardAction action = new ShowDashboardAction(dashboard);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.menu, -1);
        }
        new MenuItem(this.menu, 2);
        ActionContributionItem item = new ActionContributionItem((IAction)new AddDashboardAction());
        item.fill(this.menu, -1);
        item = new ActionContributionItem((IAction)new DuplicateDashboardAction());
        item.fill(this.menu, -1);
        new MenuItem(this.menu, 2);
        item = new ActionContributionItem((IAction)new RemoveDashboardAction());
        item.fill(this.menu, -1);
        item = new ActionContributionItem((IAction)new RemoveAllDashboardsAction());
        item.fill(this.menu, -1);
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dashboards.isEmpty()) {
            return null;
        }
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        for (Dashboard dashboard : this.dashboards.getDashboards()) {
            ShowDashboardAction action = new ShowDashboardAction(dashboard);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.menu, -1);
        }
        new MenuItem(this.menu, 2);
        ActionContributionItem item = new ActionContributionItem((IAction)new AddDashboardAction());
        item.fill(this.menu, -1);
        item = new ActionContributionItem((IAction)new DuplicateDashboardAction());
        item.fill(this.menu, -1);
        new MenuItem(this.menu, 2);
        item = new ActionContributionItem((IAction)new RemoveDashboardAction());
        item.fill(this.menu, -1);
        item = new ActionContributionItem((IAction)new RemoveAllDashboardsAction());
        item.fill(this.menu, -1);
        return this.menu;
    }

    public void dispose() {
    }

    public void runWithEvent(Event e) {
        Widget item = e.widget;
        ToolItem ti = (ToolItem)item;
        Menu m = this.getMenu((Control)ti.getParent());
        if (m != null) {
            Rectangle rect = ti.getBounds();
            Point point = ti.getParent().toDisplay(new Point(rect.x, rect.y));
            m.setLocation(point.x, point.y + ti.getParent().getBounds().height);
            m.setVisible(true);
            return;
        }
        new AddDashboardAction().run();
    }

    class AddDashboardAction
    extends Action {
        public AddDashboardAction() {
            this.setText("Add new dashboard..");
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
        }

        public void run() {
            String wname = WorkspaceHolder.getInstance().getCurrentWorkspace().getName();
            InputDialog dlg = new InputDialog(Application.getShell(), "New dashboard", "There are no dashboards yet, would you like to create one?", wname, null);
            if (dlg.open() != 0) {
                return;
            }
            Dashboard dashboard = ListDashboardsAction.this.dashboards.add(dlg.getValue());
            new ShowDashboardAction(dashboard).run();
        }
    }

    class DuplicateDashboardAction
    extends Action {
        public DuplicateDashboardAction() {
            this.setText("Duplicate dashboard..");
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
        }

        public void run() {
            ChoiceModel choice = new ChoiceModel(ListDashboardsAction.this.dashboards.getDashboards());
            choice.setSingleSelection(true);
            ListSelectionDialog sd = new ListSelectionDialog("Select dashboard to duplicate", "icons/dashboard.gif", choice, false);
            if (sd.open() != 0) {
                return;
            }
            String name = choice.getSelectionAsString()[0];
            InputDialog input = new InputDialog(Application.getShell(), "Dashboard name", "New name:", name + "(copy)", null);
            if (input.open() != 0) {
                return;
            }
            Dashboard clone = ListDashboardsAction.this.dashboards.clone(name, input.getValue());
            new ShowDashboardAction(clone).run();
        }
    }

    class RemoveAllDashboardsAction
    extends Action {
        public RemoveAllDashboardsAction() {
            this.setText("Remove all dashboards");
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_clear.gif"));
        }

        public void run() {
            if (!MessageDialog.openConfirm((Shell)Application.getShell(), (String)"Please confirm", (String)"Remove all existing dashboards?")) {
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            for (IEditorPart editor : Utils.findEditors(DashboardEditor.class)) {
                page.closeEditor(editor, true);
            }
            ListDashboardsAction.this.dashboards.clear();
        }
    }

    class RemoveDashboardAction
    extends Action {
        public RemoveDashboardAction() {
            this.setText("Remove dashboard..");
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/close.gif"));
        }

        public void run() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ChoiceModel choice = new ChoiceModel(ListDashboardsAction.this.dashboards.getDashboards());
            ListSelectionDialog dialog = new ListSelectionDialog("Select dashboards to remove", "icons/dashboard.gif", choice, false);
            if (dialog.open() != 0) {
                return;
            }
            String[] stringArray = choice.getSelectionAsString();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                IEditorPart editor = Utils.findEditor(name, DashboardEditor.class);
                if (editor != null) {
                    page.closeEditor(editor, true);
                }
                ListDashboardsAction.this.dashboards.remove(name);
                if (name.equals(ListDashboardsAction.this.getText())) {
                    ListDashboardsAction.this.setText("My dashboards");
                }
                ++n2;
            }
        }
    }

    class ShowDashboardAction
    extends Action {
        private IEditorInput input;

        public ShowDashboardAction(Dashboard dashboard) {
            this.input = new DashboardEditorInput(dashboard);
            this.setText(dashboard.getName());
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/dashboard.gif"));
        }

        public void run() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = Utils.findEditor(this.input.getName(), DashboardEditor.class);
            if (editor != null) {
                page.activate((IWorkbenchPart)editor);
                return;
            }
            try {
                page.openEditor(this.input, "com.moonlit.logfaces.client.editors.DashboardEditor");
                ListDashboardsAction.this.dashboards.setLastUsed(this.input.getName());
            }
            catch (Exception e) {
                Utils.displayPopup("Error", "Error opening view:" + e.getMessage(), true);
            }
        }
    }
}

