/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.JiraIssueSubmitDialog;
import com.moonlit.logfaces.client.jobs.JiraJob;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.ActionFactory;

public class JiraAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private TableItem[] selection;

    public JiraAction(TableItem[] selection) {
        super("Send to JIRA..");
        this.selection = selection;
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/jira.png"));
    }

    public void run() {
        if (this.selection == null || this.selection.length == 0) {
            return;
        }
        Shell shell = Application.getShell();
        try {
            LogEvent first = ((LoggingEventVO)this.selection[0].getData()).toLoggingEvent();
            String summary = StringUtils.abbreviate((String)first.getMessage().toString(), (int)60);
            JiraIssueSubmitDialog dialog = new JiraIssueSubmitDialog(shell, summary);
            if (dialog.open() != 0) {
                return;
            }
            File attachment = File.createTempFile("lfs-", ".log");
            attachment.deleteOnExit();
            FileUtils.write((File)attachment, (CharSequence)Utils.formatEvents(this.selection, null));
            JiraJob job = new JiraJob(dialog.getSummary(), dialog.getDescription(), dialog.getTemplate(), attachment);
            job.setUser(true);
            job.schedule();
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)shell, (String)"Failed", (String)ex.getMessage());
        }
    }

    public void dispose() {
    }
}

