/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportWorkspaceAction
extends Action {
    public ImportWorkspaceAction() {
        this.setText("Import workspace from file");
        this.setToolTipText("Import workspace from file");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_import.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            Shell shell = new Shell(window.getShell());
            shell.setLayout((Layout)new FillLayout());
            FileDialog dialog = new FileDialog(shell);
            dialog.setText("Import workspace file name");
            dialog.setFilterExtensions(new String[]{"*.lfs", "*.*"});
            dialog.setFilterNames(new String[]{"logFaces Workspace files (*.lfs)", "All files (*.*)"});
            String path = dialog.open();
            if (path == null) {
                return;
            }
            String wsname = "My workspace";
            if (!Application.isServerMode()) {
                String[] split = StringUtils.tokenizeToStringArray(dialog.getFileName(), ".");
                String defaultName = split.length == 0 ? dialog.getFileName() : split[0];
                InputDialog input = new InputDialog(shell, "Workspace name", "Give a friendly name to new workspace:", defaultName, null);
                if (input.open() != 0) {
                    return;
                }
                wsname = input.getValue();
            }
            try {
                window.getActivePage().closeAllEditors(false);
                LfsConnector.getInstance().terminate();
                WorkspaceHolder.getInstance().importNew(wsname, path);
                MessageDialog.openInformation((Shell)shell, (String)"Done", (String)"Workspace successfully imported");
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)shell, (String)"Import failed", (String)ex.getMessage());
            }
        }
    }
}

