/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.jobs.SyncPluginsJob;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportPluginsAction
extends Action {
    private Runnable callback;
    private static final Logger log = LogManager.getLogger(ImportPluginsAction.class);

    public ImportPluginsAction(Runnable callback) {
        this.callback = callback;
        this.setText("Import plugins from server");
        this.setToolTipText("Lets selecting and downloading server shared plugins into this workspace");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_import.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        LfsConnector connector = LfsConnector.getInstance();
        if (!connector.isConnected()) {
            MessageDialog.openError((Shell)window.getShell(), (String)"No connection", (String)"Unable to list shared plugins because there is no connection to logFaces server");
            return;
        }
        try {
            connector = LfsConnector.getInstance();
            List list = connector.getConnection().listPlugins(connector.getSid());
            if (list.isEmpty()) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)"Nothing to import", (String)"This server doesn't have any shared plugins.");
                this.callback.run();
                return;
            }
            ChoiceModel choice = new ChoiceModel(list);
            ListSelectionDialog dlg = new ListSelectionDialog("Select plugins to import", "/icons/plugin.gif", choice, false);
            if (dlg.open() == 0) {
                List<String> names = Arrays.asList(choice.getSelectionAsString());
                SyncPluginsJob job = new SyncPluginsJob(names, this.callback);
                job.setUser(true);
                job.schedule();
                return;
            }
        }
        catch (UndeclaredThrowableException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not supported", (String)"This server version doesn't support shared workspaces.\nConsider upgrading.");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            MessageDialog.openError((Shell)window.getShell(), (String)"Import failed", (String)(cause != null ? cause.getMessage() : e.getMessage()));
        }
        this.callback.run();
    }
}

