/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.ImportDataJob;
import com.moonlit.logfaces.client.net.LfsConnector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportDataAction
extends Action {
    public ImportDataAction() {
        this.setText("Import data into database");
        this.setToolTipText("Import external data into the database manually");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_import.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (LfsConnector.getInstance().getConnection() == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
            return;
        }
        Shell shell = new Shell(window.getShell());
        shell.setLayout((Layout)new FillLayout());
        FileDialog dialog = new FileDialog(shell);
        dialog.setText("Import data from...");
        dialog.setFilterExtensions(new String[]{"*.lfb", "*.xml", "*.*"});
        dialog.setFilterNames(new String[]{"logFaces export files (*.lfb)", "log4j xml files (*.xml)", "All files (*.*)"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        InputDialog dlg = new InputDialog(window.getShell(), "Replace domain name?", "Specify a domain name if you want to associate this import with particular domain (application). Otherwise leave this field blank and data will be imported unmodified.", null, null);
        if (dlg.open() != 0) {
            return;
        }
        String domain = dlg.getValue();
        if (domain != null && domain.length() == 0) {
            domain = null;
        }
        ImportDataJob job = new ImportDataJob(path, domain);
        job.setUser(true);
        job.schedule();
    }
}

