/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.net.NotConnectedException;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.ActionFactory;

public class IgnoreAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private PerspectiveVO vo;
    private LogView view;
    private Type type;

    public IgnoreAction(LogView view, PerspectiveVO vo, Type type) {
        this.view = view;
        this.vo = vo;
        this.type = type;
        this.setId(((Object)((Object)this)).getClass().getName());
        switch (type) {
            case DOMAIN: {
                this.setText("selected domain(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/domain.gif"));
                break;
            }
            case HOST: {
                this.setText("selected host(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/host.gif"));
                break;
            }
            case LOGGER: {
                this.setText("selected logger(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
                break;
            }
            case PACKAGE: {
                this.setText("selected package(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/package_obj.gif"));
                break;
            }
            case COMPONENT: {
                this.setText("selected component(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/component.gif"));
                break;
            }
            case THREAD: {
                this.setText("selected thread(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/trace_start.gif"));
                break;
            }
            case LOCATION: {
                this.setText("selected code location(s)");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_view.gif"));
            }
        }
    }

    public void run() {
        switch (this.type) {
            case DOMAIN: {
                this.ignoreDomain();
                break;
            }
            case HOST: {
                this.ignoreHost();
                break;
            }
            case LOGGER: {
                this.ignoreLogger();
                break;
            }
            case PACKAGE: {
                this.ignorePackage();
                break;
            }
            case COMPONENT: {
                this.ignoreComponent();
                break;
            }
            case THREAD: {
                this.ignoreThread();
                break;
            }
            case LOCATION: {
                this.ignoreLocation();
            }
        }
        this.saveToServer();
        this.view.getModel().applyCriteria(this.vo.getCriteria());
        this.view.refresh(false);
    }

    public void dispose() {
    }

    private void ignoreDomain() {
        HashSet<String> ignored = new HashSet<String>();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            ignored.add(event.getDomainName());
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String domain : ignored) {
                rule.addCondition((Object)EventAttribute.domainName, (Object)Operation.isnot, (Object)domain);
            }
        }
    }

    private void ignoreHost() {
        HashSet<String> ignored = new HashSet<String>();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            ignored.add(event.getHostName());
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String host : ignored) {
                rule.addCondition((Object)EventAttribute.hostName, (Object)Operation.isnot, (Object)host);
            }
        }
    }

    private void ignoreLogger() {
        HashSet<String> ignored = new HashSet<String>();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            ignored.add(event.getLoggerName());
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String ignore : ignored) {
                rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.isnot, (Object)ignore);
            }
        }
    }

    private void ignorePackage() {
        HashSet<String> ignored = new HashSet<String>();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            ignored.add(event.getLoggerNamePackage());
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String ignore : ignored) {
                rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.notcontains, (Object)ignore);
            }
        }
    }

    private void ignoreThread() {
        HashSet<String> ignored = new HashSet<String>();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            ignored.add(event.getThreadName());
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String thread : ignored) {
                rule.addCondition((Object)EventAttribute.threadName, (Object)Operation.isnot, (Object)thread);
            }
        }
    }

    private void ignoreComponent() {
        HashSet<String> ignored = new HashSet<String>();
        ComponentsModel components = ComponentsModel.getInstance();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            String[] packages = components.getPackageNames(event);
            ignored.addAll(Arrays.asList(packages));
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String pack : ignored) {
                rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.notcontains, (Object)pack);
            }
        }
    }

    public void ignoreLocation() {
        HashSet<String> ignored = new HashSet<String>();
        TableItem[] tableItemArray = this.view.getTableViewer().getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LoggingEventVO event = (LoggingEventVO)item.getData();
            ignored.add(event.getLocMethodName());
            ++n2;
        }
        for (Rule rule : this.vo.getCriteria().getRules()) {
            for (String method : ignored) {
                rule.addCondition((Object)EventAttribute.locMethodName, (Object)Operation.isnot, (Object)method);
            }
        }
    }

    private boolean saveToServer() {
        try {
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            if (connection == null) {
                throw new NotConnectedException();
            }
            connection.setupPerspective(LfsConnector.getInstance().getSid(), this.vo.getName(), this.vo.getCriteria());
            return true;
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Operation failed", (String)e.getMessage());
            return false;
        }
    }

    public static enum Type {
        DOMAIN,
        HOST,
        LOGGER,
        PACKAGE,
        COMPONENT,
        THREAD,
        LOCATION;

    }
}

