/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class FollowEventAction
extends Action {
    private PerspectiveVO perspective = new PerspectiveVO();

    public FollowEventAction(LoggingEventVO drillEvent, String attribute, String matchText) {
        this.setId(((Object)((Object)this)).getClass().getName());
        switch (EventAttribute.fromString((String)attribute)) {
            case domainName: {
                this.setText(String.format("domain '%s'", drillEvent.getDomainName()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/domain.gif"));
                this.perspective.setName(drillEvent.getDomainName());
                this.perspective.getCriteria().addRule().addCondition((Object)attribute, (Object)Operation.is, (Object)drillEvent.getDomainName());
                break;
            }
            case hostName: {
                this.setText(String.format("host '%s'", drillEvent.getHostName()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/host.gif"));
                this.perspective.setName(drillEvent.getHostName());
                this.perspective.getCriteria().addRule().addCondition((Object)attribute, (Object)Operation.is, (Object)drillEvent.getHostName());
                break;
            }
            case loggerName: {
                this.setText(String.format("logger '%s'", drillEvent.getLoggerNameShort()));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
                this.perspective.setName(drillEvent.getLoggerNameShort());
                this.perspective.getCriteria().addRule().addCondition((Object)attribute, (Object)Operation.is, (Object)drillEvent.getLoggerName());
                break;
            }
            case threadName: {
                this.setText(String.format("thread '%s'", drillEvent.getThreadName().replace("@", " ")));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/trace_start.gif"));
                this.perspective.setName(drillEvent.getThreadName().replace("@", " "));
                this.perspective.getCriteria().addRule().addCondition((Object)attribute, (Object)Operation.is, (Object)drillEvent.getThreadName());
                break;
            }
            case message: {
                String text = matchText != null && !matchText.isEmpty() ? matchText : drillEvent.getMessage();
                this.setText(StringUtils.abbreviate((String)text, (int)16));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/textfield.gif"));
                this.perspective.setName(StringUtils.abbreviate((String)text, (int)16));
                this.perspective.getCriteria().addRule().addCondition((Object)attribute, (Object)Operation.contains, (Object)text);
                break;
            }
            case throwableInfo: {
                String text = matchText != null && !matchText.isEmpty() ? matchText : drillEvent.getExceptionClass();
                this.setText(StringUtils.abbreviate((String)text, (int)16));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/thrown.gif"));
                this.perspective.setName(StringUtils.abbreviate((String)text, (int)16));
                this.perspective.getCriteria().addRule().addCondition((Object)EventAttribute.thrown, (Object)Operation.is, (Object)Boolean.TRUE).addCondition((Object)attribute, (Object)Operation.contains, (Object)text);
                break;
            }
            case mdc: {
                String value = drillEvent.getProperty(attribute);
                this.setText(String.format("%s '%s'", attribute, value));
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/prop_ps.gif"));
                this.perspective.setName(value);
                this.perspective.getCriteria().addRule().addCondition((Object)attribute, (Object)Operation.is, (Object)value);
                break;
            }
        }
    }

    public FollowEventAction(LoggingEventVO drillEvent, ComponentModel component) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText(String.format("component '%s'", component.getName()));
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/component.gif"));
        JexlCriteria criteria = new JexlCriteria();
        String[] stringArray = component.getPackageNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            criteria.addRule().addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack);
            ++n2;
        }
        this.perspective.setCriteria((CriteriaFilter)criteria);
        this.perspective.setName(component.getName());
    }

    public FollowEventAction(LoggingEventVO drillEvent, TagVO tag) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText(String.format("tag '%s'", tag.getName()));
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/tag.gif"));
        this.perspective.setCriteria(tag.getCriteria());
        this.perspective.setName(tag.getName());
    }

    public FollowEventAction(GisLocation location) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText(String.format("Follow '%s' in real time", location.getIp()));
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/map.gif"));
        JexlCriteria criteria = new JexlCriteria();
        criteria.addRule().addCondition((Object)EventAttribute.hostName, (Object)Operation.contains, (Object)location.getIp());
        criteria.addRule().addCondition((Object)EventAttribute.message, (Object)Operation.contains, (Object)location.getIp());
        for (String name : MdcMap.getNames()) {
            criteria.addRule().addCondition((Object)name, (Object)Operation.contains, (Object)location.getIp());
        }
        this.perspective.setCriteria((CriteriaFilter)criteria);
        this.perspective.setName(String.format("Tracing %s", location.getIp()));
    }

    public void run() {
        this.perspective.setActivated(true);
        this.perspective.setHeaders((LogHeaderInfoVO[])Utils.getContextVariable("headers"));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        LogEditorInput input = new LogEditorInput(this.perspective);
        IWorkbenchPage page = window.getActivePage();
        try {
            page.openEditor((IEditorInput)input, "com.moonlit.logfaces.client.LogEditor");
        }
        catch (PartInitException e) {
            MessageDialog.openError(null, (String)"Operation failed", (String)e.getMessage());
        }
    }
}

