/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.FindDialog;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.views.MessageView;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FindAction
extends Action
implements IPartListener {
    private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public FindAction() {
        this.setText("Find");
        this.setToolTipText("Find");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/feed.gif"));
        this.setId("lfs.command.find");
        this.setActionDefinitionId("lfs.command.find");
        this.window.getPartService().addPartListener((IPartListener)this);
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return false;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return false;
        }
        return editor instanceof LogView || editor instanceof Searchable;
    }

    public void run() {
        String selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        FindDialog.getInstance().activate(editor);
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof MessageView && StringUtils.hasText(selection = ((MessageView)part).getSelection())) {
            FindDialog.getInstance().setText(selection);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.setEnabled(this.isEnabled());
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.setEnabled(this.isEnabled());
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

