/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Filterable;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.filters.AttributeMatcher;
import com.moonlit.logfaces.client.model.filters.ComponentMatcher;
import com.moonlit.logfaces.client.model.filters.LogViewFilter;
import com.moonlit.logfaces.client.model.filters.PropertyMatcher;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.actions.ActionFactory;

public class FilterAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private LoggingEventVO event;
    private LogViewFilter filter;
    private Filterable filterable;
    private TYPE type;
    private String mdcValue;
    private int mdcIndex;
    private int column;
    private TagVO tag;
    private ComponentsModel components = ComponentsModel.getInstance();

    public FilterAction(TYPE type, Filterable filterable) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.type = type;
        this.filterable = filterable;
        this.event = filterable.getFilterEvent();
        this.filter = filterable.getViewFilter();
        switch (type) {
            case FOCUS_DOMAIN: 
            case IGNORE_DOMAIN: {
                this.setText("from this domain (" + this.event.getDomainName() + ")");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/domain.gif"));
                this.column = 5;
                break;
            }
            case FOCUS_COMPONENT: 
            case IGNORE_COMPONENT: {
                this.setText("from this component (" + this.components.getComponent(this.event) + ")");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/component.gif"));
                this.column = 6;
                break;
            }
            case FOCUS_TAG: 
            case IGNORE_TAG: {
                this.setText("tagged (" + (String)this.event.getProperties().get("tags") + ")");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/component.gif"));
                this.column = 1;
                break;
            }
            case FOCUS_HOST: 
            case IGNORE_HOST: {
                this.setText("from this host (" + this.event.getHostName() + ")");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/host.gif"));
                this.column = 4;
                break;
            }
            case FOCUS_LOGGER: 
            case IGNORE_LOGGER: {
                this.setText("from this logger (" + this.event.getLoggerNameShort() + ")");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
                this.column = 7;
                break;
            }
            case FOCUS_THREAD: 
            case IGNORE_THREAD: {
                this.setText("from this thread (" + this.event.getThreadName() + ")");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/trace_start.gif"));
                this.column = 8;
                break;
            }
            case FOCUS_MESSAGE: 
            case IGNORE_MESSAGE: {
                this.setText("containing this text...");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_edit.gif"));
                this.column = 12;
                break;
            }
        }
    }

    public FilterAction(TYPE type, Filterable filterable, int mdcIndex, String mdcValue) {
        this(type, filterable);
        this.mdcIndex = mdcIndex;
        this.mdcValue = mdcValue;
        this.column = 12 + mdcIndex + 1;
        this.setText(String.format("where %s is '%s'", MdcMap.getName((int)mdcIndex), mdcValue));
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/prop_ps.gif"));
    }

    public FilterAction(TYPE type, Filterable filterable, TagVO tag) {
        this(type, filterable);
        this.column = 1;
        this.tag = tag;
        this.setText(String.format("tagged as '%s'", tag.getName()));
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/tag.gif"));
    }

    public void run() {
        switch (this.type) {
            case FOCUS_DOMAIN: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.domainName, Operation.is, this.event.getDomainName()));
                break;
            }
            case IGNORE_DOMAIN: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.domainName, Operation.isnot, this.event.getDomainName()));
                break;
            }
            case FOCUS_COMPONENT: {
                this.filter.addMatcher(new ComponentMatcher(Operation.is, this.components.getComponent(this.event)));
                break;
            }
            case IGNORE_COMPONENT: {
                this.filter.addMatcher(new ComponentMatcher(Operation.isnot, this.components.getComponent(this.event)));
                break;
            }
            case FOCUS_TAG: {
                this.filter.addMatcher(new PropertyMatcher(Operation.is, "tags", this.tag.getName()));
                break;
            }
            case IGNORE_TAG: {
                this.filter.addMatcher(new PropertyMatcher(Operation.isnot, "tags", this.tag.getName()));
                break;
            }
            case FOCUS_LOGGER: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.loggerName, Operation.is, this.event.getLoggerName()));
                break;
            }
            case IGNORE_LOGGER: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.loggerName, Operation.isnot, this.event.getLoggerName()));
                break;
            }
            case FOCUS_HOST: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.hostName, Operation.is, this.event.getHostName()));
                break;
            }
            case IGNORE_HOST: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.hostName, Operation.isnot, this.event.getHostName()));
                break;
            }
            case FOCUS_THREAD: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.threadName, Operation.is, this.event.getThreadName()));
                break;
            }
            case IGNORE_THREAD: {
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.threadName, Operation.isnot, this.event.getThreadName()));
                break;
            }
            case FOCUS_MESSAGE: {
                String match = this.askForMessage();
                if (match == null) break;
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.message, Operation.is, String.format("*%s*", match)));
                break;
            }
            case IGNORE_MESSAGE: {
                String match = this.askForMessage();
                if (match == null) break;
                this.filter.addMatcher(new AttributeMatcher(EventAttribute.message, Operation.isnot, String.format("*%s*", match)));
                break;
            }
            case FOCUS_MDC: {
                this.filter.addMatcher(new PropertyMatcher(Operation.is, MdcMap.getName((int)this.mdcIndex), this.mdcValue));
                break;
            }
            case IGNORE_MDC: {
                this.filter.addMatcher(new PropertyMatcher(Operation.isnot, MdcMap.getName((int)this.mdcIndex), this.mdcValue));
                break;
            }
            default: {
                return;
            }
        }
        this.filterable.applyFilter(this.column);
    }

    private String askForMessage() {
        String prompt = this.type == TYPE.FOCUS_MESSAGE ? "Include messages containing (use * wildcard for partial matching):" : "Ignore messages containing (use * wildcard for partial matching):";
        String text = this.event.getMessage();
        text = text.length() < 80 ? text : String.valueOf(text.subSequence(0, 79)) + "...";
        InputDialog dialog = new InputDialog(null, "Match message text", prompt, text, null);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        return dialog.getValue();
    }

    public void dispose() {
    }

    public static enum TYPE {
        FOCUS_HOST,
        FOCUS_MDC,
        FOCUS_DOMAIN,
        FOCUS_COMPONENT,
        FOCUS_LOGGER,
        FOCUS_THREAD,
        FOCUS_MESSAGE,
        FOCUS_TAG,
        IGNORE_HOST,
        IGNORE_MDC,
        IGNORE_DOMAIN,
        IGNORE_COMPONENT,
        IGNORE_LOGGER,
        IGNORE_THREAD,
        IGNORE_MESSAGE,
        IGNORE_TAG;

    }
}

