/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.QueryDialog;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.FastFetch;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FastFetchAction
extends Action {
    private File fromFile;

    public FastFetchAction() {
        this.setText("Fetch");
        this.setToolTipText("Create and run query instantly");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/feed.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setActionDefinitionId("lfs.command.fetch");
    }

    public FastFetchAction(File file) {
        this.fromFile = file;
    }

    public void run() {
        QueryVO query = null;
        LfsConnector connector = LfsConnector.getInstance();
        if (!connector.isConnected()) {
            Utils.displayPopup("Error", "Not connected to server", true);
            return;
        }
        if (this.fromFile != null) {
            try {
                query = QueryVO.load(this.fromFile);
            }
            catch (Exception e) {
                Utils.displayWarning("Failed", e.getMessage());
                return;
            }
        } else {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            query = FastFetch.getInstance().getQuery().clone();
            query.setName(String.format("Fast fetch (%d)", PersistentCounter.getInstance().getCounter()));
            QueryDialog dialog = new QueryDialog(window.getShell(), query, false);
            if (dialog.open() != 0) {
                return;
            }
        }
        FastFetch.getInstance().setQuery(query);
        QueryDataFetcher fetcher = new QueryDataFetcher(query, true);
        FetchQueryRapidJob job = new FetchQueryRapidJob(fetcher);
        job.setUser(true);
        job.schedule();
    }
}

