/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExportWorkspaceAction
extends Action {
    public ExportWorkspaceAction() {
        this.setText("Export workspace to file");
        this.setToolTipText("Export current workspace into a file");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_export.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            Shell shell = new Shell(window.getShell());
            shell.setLayout((Layout)new FillLayout());
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setText("Export workspace file name");
            dialog.setFilterExtensions(new String[]{"*.lfs", "*.*"});
            dialog.setFilterNames(new String[]{"logFaces Workspace files (*.lfs)", "All files (*.*)"});
            dialog.setFileName(WorkspaceHolder.getInstance().getCurrentWorkspace().getName() + ".lfs");
            Object path = dialog.open();
            if (path == null) {
                return;
            }
            if (!((String)path).endsWith(".lfs")) {
                path = (String)path + ".lfs";
            }
            try {
                WorkspaceHolder.getInstance().export(new File((String)path));
                MessageDialog.openInformation((Shell)shell, (String)"Success", (String)"Workspace successfully exported");
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)shell, (String)"Export failed", (String)ex.getMessage());
            }
        }
    }
}

