/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportToLogFileAction
extends Action {
    private LogView view;
    private FileFormat format;
    private String name;
    private boolean editor;
    private boolean promptFile;
    private String path;

    public ExportToLogFileAction(LogView view, String name, FileFormat format) {
        this(view, name, format, true, false);
    }

    public ExportToLogFileAction(LogView view, String name, FileFormat format, boolean promptFile, boolean editor) {
        this.view = view;
        this.format = format;
        this.name = name;
        this.promptFile = promptFile;
        this.editor = editor;
        switch (format) {
            case pattern: {
                this.setText(editor ? "Text editor" : "Formatted log file");
                this.setImageDescriptor(MainPlugin.getImageDescriptor(editor ? "icons/eclipse3_edit.gif" : "/icons/saveas_edit.gif"));
                break;
            }
            case xml: {
                this.setText("XML file");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/saveas_edit.gif"));
                break;
            }
            case csv: {
                this.setText("CSV file");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/saveas_edit.gif"));
                break;
            }
        }
        this.path = String.format("%s%s%s.log", WorkspaceHolder.getInstance().getTempDirectoryName(), File.separator, StringUtils.replace(name, " ", "_"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        if (this.view.getModel().getViewData().size() == 0) {
            MessageDialog.openWarning((Shell)Application.getShell(), (String)"Nothing to save", (String)"There is nothing to save to file");
            return;
        }
        FileDialog dialog = new FileDialog(Application.getShell(), 8192);
        dialog.setText("Specify the file name");
        switch (this.format) {
            case pattern: {
                dialog.setFilterExtensions(new String[]{"*.log", "*.*"});
                dialog.setFilterNames(new String[]{"log files (*.log)", "All files (*.*)"});
                dialog.setFileName(this.name + ".log");
                break;
            }
            case xml: {
                dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                dialog.setFilterNames(new String[]{"xml files (*.xml)", "All files (*.*)"});
                dialog.setFileName(this.name + ".xml");
                break;
            }
            case csv: {
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"csv files (*.csv)", "All files (*.*)"});
                dialog.setFileName(this.name + ".csv");
                break;
            }
        }
        if (this.promptFile) {
            dialog.setFilterPath(System.getProperty("user.home"));
            this.path = dialog.open();
            if (this.path == null) {
                return;
            }
            if (!this.path.endsWith(".log") && this.format == FileFormat.pattern) {
                this.path = String.valueOf(this.path) + ".log";
            }
            if (!this.path.endsWith(".xml") && this.format == FileFormat.xml) {
                this.path = String.valueOf(this.path) + ".xml";
            }
            if (!this.path.endsWith(".csv") && this.format == FileFormat.csv) {
                this.path = String.valueOf(this.path) + ".csv";
            }
        }
        Utils.saveToLogFile(this.view, this.path, this.format, this.editor);
    }
}

