/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.QueryVO;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportQueryAction
extends Action {
    private QueryVO query;
    private static final Logger log = LogManager.getLogger(ExportQueryAction.class);

    public ExportQueryAction(QueryVO query) {
        this.query = query;
        this.setText("Export this query parameters to file");
        this.setToolTipText("This will create a file out of query and it can be shared with others");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/preferences.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        FileDialog dialog = new FileDialog(Application.getShell(), 8192);
        dialog.setText("Specify the file name");
        dialog.setFilterPath(System.getProperty("user.home"));
        dialog.setFilterExtensions(new String[]{"*.lfq", "*.*"});
        dialog.setFilterNames(new String[]{"query files (*.lfq)", "All files (*.*)"});
        dialog.setFileName(this.query.getName() + ".lfq");
        Object path = dialog.open();
        if (path == null) {
            return;
        }
        if (!((String)path).endsWith(".lfq")) {
            path = (String)path + ".lfq";
        }
        try {
            this.query.save(new File((String)path));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)Application.getShell(), (String)"Failed", (String)e.getMessage());
        }
    }
}

