/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.BinaryQuerySaver;
import com.moonlit.logfaces.client.jobs.SaveDataJob;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExportDataAction
extends Action {
    private QueryVO query;

    public ExportDataAction(QueryVO query) {
        this.query = query;
        this.setText("Export results to binary file");
        this.setToolTipText("Export results to binary file");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_export.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public ExportDataAction() {
        this.query = new QueryVO();
        this.query.setName("backup");
        this.query.setLimit(-1);
        this.query.setTimeRange(TimeRange.ALL, 0L, 0L);
        JexlCriteria criteria = new JexlCriteria();
        Rule rule = criteria.addRule();
        rule.addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.TRACE.intLevel());
        this.query.setCriteria((CriteriaFilter)criteria);
        this.setText("Export data from database");
        this.setToolTipText("Export data from database");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_export.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (LfsConnector.getInstance().getConnection() == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
            return;
        }
        FileDialog dialog = new FileDialog(window.getShell());
        dialog.setText("Export data to..");
        dialog.setFilterExtensions(new String[]{"*.lfb", "*.*"});
        dialog.setFilterNames(new String[]{"logFaces export files (*.lfb)", "All files (*.*)"});
        Object fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        if (!((String)fileName).endsWith(".lfb")) {
            fileName = (String)fileName + ".lfb";
        }
        BinaryQuerySaver saver = new BinaryQuerySaver(this.query.clone(), (String)fileName);
        SaveDataJob job = new SaveDataJob(saver, false);
        job.setUser(true);
        job.schedule();
    }

    public void dispose() {
    }
}

