/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyTextToClipboardAction
extends Action {
    private String text;
    private String attribute;
    private LoggingEventVO event;

    public CopyTextToClipboardAction(LoggingEventVO event, String attribute, String text) {
        this.text = text;
        this.attribute = attribute;
        this.event = event;
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText("Copy to clipboard");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
        this.setEnabled(true);
    }

    public void run() {
        String copy = "";
        switch (EventAttribute.fromString((String)this.attribute)) {
            case domainName: {
                copy = this.event.getDomainName();
                break;
            }
            case hostName: {
                copy = this.event.getHostName();
                break;
            }
            case loggerName: {
                copy = this.event.getLoggerName();
                break;
            }
            case threadName: {
                copy = this.event.getThreadName();
                break;
            }
            case message: {
                copy = this.text != null && !this.text.isEmpty() ? this.text : this.event.getMessage();
                break;
            }
            case throwableInfo: {
                copy = this.text != null && !this.text.isEmpty() ? this.text : this.event.getThrowableInfo();
                break;
            }
            case mdc: {
                copy = this.event.getProperty(this.attribute);
                break;
            }
        }
        Clipboard cb = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{copy}, new Transfer[]{textTransfer});
    }
}

