/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.utils.LogViewWriter;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.StringWriter;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class CopyTableToClipboardAction
extends Action {
    private LogView view;
    private TableItem[] selection;
    private TimeZone timeZone;
    private Type type;
    private int column;
    private static final Logger log = LogManager.getLogger(CopyTableToClipboardAction.class);

    public CopyTableToClipboardAction(LogView view, TableItem item, int column) {
        this.view = view;
        this.type = Type.COLUMN;
        this.selection = new TableItem[]{item};
        this.column = column;
        this.setText("Copy this column");
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setEnabled(true);
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
    }

    public CopyTableToClipboardAction(LogView view, TableItem[] selection, Type type, TimeZone timeZone) {
        this.view = view;
        this.type = type;
        this.selection = selection;
        this.timeZone = timeZone;
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setEnabled(true);
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
        switch (type) {
            case FORMATTED: {
                this.setText("Formatted layout");
                break;
            }
            case UNFORMATTED: {
                this.setText("Key value pair list");
                break;
            }
            case CSV: {
                this.setText("CSV of visible columns");
                break;
            }
        }
    }

    public void run() {
        String copy = "";
        switch (this.type) {
            case COLUMN: {
                LoggingEventVO event = (LoggingEventVO)this.selection[0].getData();
                if (this.view.getColumnType(this.column) == 0) {
                    copy = LfsLevel.toLevel((int)event.getLoggerLevel()).toString();
                }
                if (this.view.getColumnType(this.column) == 10) {
                    copy = event.getThrowableInfo();
                    break;
                }
                copy = this.selection[0].getText(this.column);
                break;
            }
            case FORMATTED: {
                copy = Utils.formatEvents(this.selection, this.timeZone);
                break;
            }
            case UNFORMATTED: {
                StringBuffer buff = new StringBuffer();
                TableItem[] tableItemArray = this.selection;
                int n = this.selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    LoggingEventVO event = (LoggingEventVO)item.getData();
                    buff.append(Utils.event2valuePairs((LogEvent)event));
                    buff.append(String.format("%n%n", new Object[0]));
                    ++n2;
                }
                copy = buff.toString();
                break;
            }
            case CSV: {
                try {
                    LogViewWriter writer = new LogViewWriter(this.view, new StringWriter());
                    writer.write(this.selection);
                    copy = writer.getWriter().toString();
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    MessageDialog.openError((Shell)Application.getShell(), (String)e.getClass().getName(), (String)e.getMessage());
                    return;
                }
            }
        }
        if (!StringUtils.hasText(copy)) {
            return;
        }
        Clipboard cb = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{copy}, new Transfer[]{textTransfer});
    }

    public static enum Type {
        COLUMN,
        FORMATTED,
        UNFORMATTED,
        CSV;

    }
}

