/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.server.core.LogEvent;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.ActionFactory;

public class BookmarksAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private Table table;
    private List<LogEvent> events;
    private boolean add = false;

    public BookmarksAction(Table table, TableItem[] items, boolean add) {
        super("bookmarks");
        this.table = table;
        this.events = Lists.newArrayList();
        this.add = add;
        this.setText(add ? "Add bookmarks" : "Remove bookmarks");
        this.setImageDescriptor(MainPlugin.getImageDescriptor(add ? "icons/bookmark.gif" : "icons/eclipse3_remove.gif"));
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.events.add((LogEvent)item.getData());
            ++n2;
        }
    }

    public void run() {
        try {
            LogDataModel model = (LogDataModel)this.table.getData();
            for (LogEvent event : this.events) {
                if (this.add) {
                    model.addBookmark(event);
                    continue;
                }
                model.removeBookmark(event);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

