/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.model.data.AnnotationType;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.server.core.LogEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.ActionFactory;

public class BookmarkAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private Table table;
    private LogEvent event;

    public BookmarkAction(Table table) {
        this(table, null);
    }

    public BookmarkAction(Table table, LogEvent event) {
        super("bookmark");
        this.table = table;
        this.event = event;
        if (event == null) {
            this.setText("Clear all bookmarks");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_clear.gif"));
        } else if (TagsModel.getInstance().isBookmark(event)) {
            this.setText("Remove bookmark");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_remove.gif"));
        } else {
            this.setText("Bookmark this");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/bookmark.gif"));
        }
    }

    public void run() {
        try {
            LogDataModel model = (LogDataModel)this.table.getData();
            if (this.event == null) {
                model.removeAnnotations(AnnotationType.BOOKMARK);
            } else if (TagsModel.getInstance().isBookmark(this.event)) {
                model.removeBookmark(this.event);
            } else {
                model.addBookmark(this.event);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

