/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.embedded.LicenseManager;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.net.LfsConnector;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.dialogs.AboutDialog;

public class AboutAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public AboutAction() {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText("&About logFaces");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/lf16.png"));
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        AboutDialog about = new AboutDialog(Application.getShell()){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                String title = System.getProperty("com.moonlit.logfaces.title", null);
                if (title != null) {
                    newShell.setText(title);
                }
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Composite c = (Composite)((Composite)composite.getChildren()[0]).getChildren()[0];
                Image image = ImageHolder.getInstance().getImageExternal(System.getProperty("com.moonlit.logfaces.image", null));
                if (image != null) {
                    Label label = (Label)c.getChildren()[0];
                    label.setImage(image);
                }
                ScrolledComposite scr = (ScrolledComposite)c.getChildren()[1];
                StyledText styled = (StyledText)((Composite)scr.getChildren()[0]).getChildren()[0];
                String original = styled.getText();
                StringBuffer buf = new StringBuffer();
                buf.append(String.format("%n%n%s", AboutAction.this.getLicenseInfo()));
                styled.append(buf.toString());
                StyleRange styleRange = new StyleRange();
                styleRange.start = original.length();
                styleRange.length = buf.length();
                styleRange.foreground = EventStyles.FG_LFS;
                styled.setStyleRange(styleRange);
                this.getShell().setMinimumSize(600, 400);
                this.getShell().layout(true);
                return composite;
            }
        };
        about.open();
    }

    private String getLicenseInfo() {
        try {
            if (Application.isServerMode()) {
                return LicenseManager.getInstance().getLicenseContentString();
            }
            return LfsConnector.getInstance().getConnection().getLicenseString();
        }
        catch (Exception e) {
            return "Unable to obtain license info";
        }
    }

    public void dispose() {
    }
}

