/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.jobs.LoadWorkspaceJob;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.LfsEventBus;
import com.moonlit.logfaces.server.util.Patterns;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class WorkspaceHolder {
    private static WorkspaceHolder instance;
    private Workspace currentWorkspace;
    private IEclipsePreferences prefs;
    private String root = Platform.getConfigurationLocation().getURL().getPath();
    private File tempDir;
    private String DEFAULT_WORKSPACE_FILE_NAME = "workspace.xml";
    private String DEFAULT_WORKSPACE_RESOURCE = "default-workspace.xml";
    private String WORKSPACE_PREFIX = "workspace-";
    private Map<String, Workspace> workspaces;
    private boolean initialized;
    private static final Logger log;

    static {
        log = LogManager.getLogger(WorkspaceHolder.class);
    }

    private WorkspaceHolder() {
        File pfile;
        this.prefs = Application.getPrefs();
        this.workspaces = new HashMap<String, Workspace>();
        try {
            for (String name : this.getNames()) {
                this.workspaces.put(name, new Workspace(name, this.getFileName(name)));
            }
            if (this.workspaces.size() == 0) {
                this.createNew("My workspace", "localhost", 8050, "", "", false, false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            pfile = new File(String.format("%s%spatterns.properties", this.root, File.separator));
            if (!pfile.exists()) {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("patterns.properties"), (File)pfile);
            }
            Patterns.makeInstance((String)pfile.getPath());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            pfile = new File(String.format("%s%sdialogs.xml", this.root, File.separator));
            if (!pfile.exists()) {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("dialogs.xml"), (File)pfile);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.tempDir = new File(this.root + File.separator + "temp");
            this.tempDir.mkdir();
            FileUtils.cleanDirectory((File)this.tempDir);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static WorkspaceHolder getInstance() {
        if (instance == null) {
            instance = new WorkspaceHolder();
        }
        return instance;
    }

    public void initialize() throws Exception {
        String current = this.prefs.get("lfs_workspace_name", "My workspace");
        this.switchTo(current);
        this.initialized = true;
    }

    public Workspace addWorkspace(File file) throws Exception {
        Workspace ws = new Workspace(file.getName(), file.getCanonicalPath());
        this.workspaces.put(ws.getName(), ws);
        return ws;
    }

    public Workspace getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentWorkspace(Workspace ws) {
        this.currentWorkspace = ws;
        this.prefs.put("lfs_workspace_name", this.currentWorkspace.getName());
    }

    public Workspace getWorkspace(String name) {
        return this.workspaces.get(name);
    }

    public String getTempDirectoryName() {
        return this.tempDir.getPath();
    }

    public void save() throws Exception {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.save(true);
        }
    }

    public void saveAs(String name) throws Exception {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.saveAs(name, this.getFileName(name), true);
        }
    }

    public void createNew(String name, String host, int port, String user, String password, boolean ssl, boolean duplicate) throws Exception {
        String fileName = this.getFileName(name);
        File file = new File(fileName);
        if (duplicate && this.currentWorkspace != null) {
            this.currentWorkspace.export(file, false);
        } else {
            FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream(this.DEFAULT_WORKSPACE_RESOURCE), (File)file);
        }
        Workspace workspace = new Workspace(name, file.getCanonicalPath());
        workspace.setServerHost(host);
        workspace.setServerPort(port);
        workspace.setSsl(ssl);
        workspace.setUserName(user);
        workspace.setPassword(password);
        if (duplicate) {
            workspace.export(file, true);
        }
        this.workspaces.put(name, workspace);
    }

    public void importNew(String name, String infile) throws Exception {
        this.importNew(name, new FileInputStream(new File(infile)));
    }

    public void importNew(String name, InputStream is) throws Exception {
        String wsfile = this.getFileName(name);
        BufferedReader reader = null;
        FileWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            writer = new FileWriter(new File(wsfile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(Utils.LINE_SEPARATOR);
            }
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
        this.workspaces.put(name, new Workspace(name, wsfile));
        this.switchTo(name);
    }

    public void export(File file) throws Exception {
        this.currentWorkspace.export(file, true);
    }

    public void switchTo(String name) throws Exception {
        if (this.currentWorkspace != null && this.initialized && !this.currentWorkspace.getName().equals(name)) {
            this.currentWorkspace.save(true);
        }
        this.currentWorkspace = this.workspaces.get(name);
        LoadWorkspaceJob job = new LoadWorkspaceJob(this.currentWorkspace);
        job.setUser(true);
        job.schedule();
    }

    public void remove(String name) {
        String fileName = this.getFileName(name);
        FileUtils.deleteQuietly((File)new File(fileName));
        this.workspaces.remove(name);
        LfsEventBus.getInstance().post((Object)LfcEvent.workspaceRemoved(name));
    }

    private String getFileName(String workspaceName) {
        if (workspaceName != null) {
            if (workspaceName.equals("My workspace")) {
                return this.root + File.separator + this.DEFAULT_WORKSPACE_FILE_NAME;
            }
            return this.root + File.separator + this.WORKSPACE_PREFIX + workspaceName + ".xml";
        }
        return this.root + File.separator + this.DEFAULT_WORKSPACE_FILE_NAME;
    }

    public Collection<String> getNames() {
        IOFileFilter filter1 = FileFilterUtils.prefixFileFilter((String)this.WORKSPACE_PREFIX);
        IOFileFilter filter2 = FileFilterUtils.suffixFileFilter((String)".xml");
        WorkspaceWalker walker = new WorkspaceWalker((IOFileFilter)new AndFileFilter(filter1, filter2));
        return Sets.newTreeSet(walker.list());
    }

    class WorkspaceWalker
    extends DirectoryWalker {
        WorkspaceWalker(IOFileFilter filter) {
            super((FileFilter)filter, 1);
        }

        public List<String> list() {
            ArrayList<String> names = new ArrayList<String>();
            if (new File(WorkspaceHolder.this.getFileName("My workspace")).exists()) {
                names.add("My workspace");
            }
            try {
                this.walk(new File(WorkspaceHolder.this.root), names);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return names;
        }

        protected void handleFile(File file, int depth, Collection results) {
            String name = file.getName();
            int from = WorkspaceHolder.this.WORKSPACE_PREFIX.length();
            int to = name.length() - 4;
            name = name.substring(from, to);
            results.add(name);
        }
    }
}

