/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.dashboard.DashboardsModel;
import com.moonlit.logfaces.client.gis.GIS;
import com.moonlit.logfaces.client.jobs.ReconnectJob;
import com.moonlit.logfaces.client.model.ColumnSetModel;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.CountersModel;
import com.moonlit.logfaces.client.model.FastFetch;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.ParsersModel;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.SourceMappingModel;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.ColorPicker;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class Workspace {
    private String name;
    private String fileName;
    private String serverHost = "localhost";
    private int serverPort = 8050;
    private String userName = "";
    private String password = "";
    private boolean loginRequired;
    private boolean autoLogin;
    private boolean ssl;
    private static final Logger log = LogManager.getLogger(Workspace.class);

    public Workspace(String name, String fileName) {
        this.name = name;
        this.fileName = fileName;
        try {
            IMemento root;
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new FileReader(fileName));
            String temp = memento.getString("name");
            if (!StringUtils.isBlank((CharSequence)temp)) {
                this.name = temp;
            }
            if ((root = memento.getChild("server")) != null) {
                this.serverHost = root.getString("host");
                this.serverPort = root.getInteger("port");
                try {
                    this.ssl = root.getBoolean("ssl");
                }
                catch (Exception exception) {}
            } else {
                IEclipsePreferences prefs = Application.getPrefs();
                this.serverHost = prefs.get("lfs_host_name", "localhost");
                this.serverPort = prefs.getInt("lfs_port_num", 8050);
                this.ssl = prefs.getBoolean("lfs_ssl", false);
            }
            if ((root = memento.getChild("credentials")) != null) {
                this.userName = root.getString("userName");
                this.password = root.getString("password");
                this.loginRequired = root.getBoolean("loginRequired") == null ? false : root.getBoolean("loginRequired");
                this.autoLogin = root.getBoolean("autoLogin") == null ? false : root.getBoolean("autoLogin");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void load() throws Exception {
        log.info("loading workspace '{}'", (Object)this.name);
        IEclipsePreferences prefs = Application.getPrefs();
        prefs.put("lfs_workspace_name", this.name);
        prefs.put("lfs_host_name", this.serverHost);
        prefs.putInt("lfs_port_num", this.serverPort);
        prefs.putBoolean("lfs_ssl", this.ssl);
        prefs.put("lfs_user", this.userName);
        prefs.put("lfs_pwd", this.password);
        prefs.flush();
        this.reconnect(true);
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new FileReader(this.fileName));
        String temp = memento.getString("name");
        if (!StringUtils.isBlank((CharSequence)temp)) {
            this.name = temp;
        }
        try {
            String headers = memento.getChild("visual").getString("headers");
            Columns.setDefaultHeaders(headers);
        }
        catch (Exception e) {
            log.warn("unable to read {}", (Object)"lfs_headers");
        }
        IMemento jm = memento.getChild("jira");
        prefs.putBoolean("jira_enabled", jm != null ? jm.getBoolean("enabled") : false);
        prefs.put("jira_url", jm != null ? jm.getString("url") : "");
        prefs.put("jira_user", jm != null ? jm.getString("userName") : "");
        prefs.put("jira_token", jm != null ? jm.getString("token") : "");
        LogPerspectivesModel.getInstance().load((IMemento)memento);
        CountersModel.getInstance().load((IMemento)memento);
        ComponentsModel.getInstance().load((IMemento)memento);
        QueryModel.getInstance().load((IMemento)memento);
        TagsModel.getInstance().load((IMemento)memento);
        DashboardsModel.getInstance().load((IMemento)memento);
        ParsersModel.getInstance().load((IMemento)memento);
        RegexModel.getInstance().load((IMemento)memento);
        FastFetch.getInstance().load((IMemento)memento);
        SourceMappingModel.getInstance().load((IMemento)memento);
        ColumnSetModel.getInstance().load((IMemento)memento);
        PluginsDelegate.getInstance().load((IMemento)memento);
        GIS.getInstance().load((IMemento)memento);
        ColorPicker.getInstance().init();
    }

    public void reconnect(boolean join) {
        if (Application.isServerMode()) {
            return;
        }
        log.info("reconnect workspace '{}'", (Object)this.name);
        IEclipsePreferences prefs = Application.getPrefs();
        this.serverHost = prefs.get("lfs_host_name", "localhost");
        this.serverPort = prefs.getInt("lfs_port_num", 8050);
        this.ssl = prefs.getBoolean("lfs_ssl", false);
        this.userName = prefs.get("lfs_user", "");
        this.password = prefs.get("lfs_pwd", "");
        boolean reconnect = !LfsConnector.getInstance().isConnectedTo(this.serverHost, this.serverPort, this.ssl);
        ReconnectJob job = new ReconnectJob(reconnect);
        job.setUser(true);
        job.schedule();
        try {
            if (join) {
                job.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void save(boolean includeCridentials) throws Exception {
        log.info("save workspace '{}'", (Object)this.name);
        new File(this.fileName).createNewFile();
        FileWriter writer = new FileWriter(this.fileName);
        XMLMemento memento = this.createMemento(includeCridentials);
        memento.save((Writer)writer);
    }

    public void save(String name, OutputStream os, boolean includeCridentials) throws Exception {
        log.info("save workspace '{}'", (Object)name);
        XMLMemento memento = this.createMemento(includeCridentials);
        memento.putString("name", name);
        OutputStreamWriter writer = new OutputStreamWriter(os);
        memento.save((Writer)writer);
    }

    public void saveAs(String name, String file, boolean includeCridentials) throws Exception {
        log.info("save as workspace '{}'", (Object)name);
        this.name = name;
        this.fileName = file;
        FileWriter writer = new FileWriter(this.fileName);
        XMLMemento memento = this.createMemento(includeCridentials);
        memento.save((Writer)writer);
    }

    public void export(File file, boolean includeCridentials) throws Exception {
        log.info("export workspace '{}'", (Object)this.name);
        FileWriter writer = new FileWriter(file);
        XMLMemento memento = this.createMemento(includeCridentials);
        memento.save((Writer)writer);
    }

    private XMLMemento createMemento(boolean includeCridentials) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"lfs-workspace");
        memento.putString("name", this.name);
        IMemento parent = memento.createChild("server");
        parent.putString("host", this.serverHost);
        parent.putInteger("port", this.serverPort);
        parent.putBoolean("ssl", this.ssl);
        parent = memento.createChild("visual");
        parent.putString("headers", StringUtils.join(Columns.getDefaultHeaders(), (String)","));
        if (includeCridentials) {
            parent = memento.createChild("credentials");
            parent.putString("userName", this.userName != null ? this.userName : "");
            parent.putString("password", this.password != null ? this.password : "");
            parent.putBoolean("loginRequired", this.loginRequired);
            parent.putBoolean("autoLogin", this.autoLogin);
        }
        IEclipsePreferences prefs = Application.getPrefs();
        parent = memento.createChild("jira");
        parent.putString("enabled", prefs.get("jira_enabled", "false"));
        parent.putString("url", prefs.get("jira_url", ""));
        parent.putString("userName", prefs.get("jira_user", ""));
        parent.putString("token", prefs.get("jira_token", ""));
        LogPerspectivesModel.getInstance().save((IMemento)memento);
        CountersModel.getInstance().save((IMemento)memento);
        QueryModel.getInstance().save((IMemento)memento);
        TagsModel.getInstance().save((IMemento)memento);
        DashboardsModel.getInstance().save((IMemento)memento);
        FastFetch.getInstance().save((IMemento)memento);
        ComponentsModel.getInstance().save((IMemento)memento);
        SourceMappingModel.getInstance().save((IMemento)memento);
        ColumnSetModel.getInstance().save((IMemento)memento);
        ParsersModel.getInstance().save((IMemento)memento);
        RegexModel.getInstance().save((IMemento)memento);
        PluginsDelegate.getInstance().save((IMemento)memento);
        GIS.getInstance().save((IMemento)memento);
        return memento;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    public void setLoginRequired(boolean loginRequired) {
        this.loginRequired = loginRequired;
    }

    public boolean isAutoLogin() {
        return this.autoLogin;
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getConnectionUrl() {
        return String.format("%s://%s:%d/remote", this.ssl ? "https" : "http", this.serverHost, this.serverPort);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

