/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.AuthDialog;
import com.moonlit.logfaces.client.net.LfsConnector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;

public class LoginHandler {
    private static LoginHandler instance;
    private static final Logger log;

    static {
        log = LogManager.getLogger(LoginHandler.class);
    }

    public static LoginHandler getInstance() {
        if (instance == null) {
            instance = new LoginHandler();
        }
        return instance;
    }

    public void login() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LfsConnector connector = LfsConnector.getInstance();
                if (connector.isLoginRequired()) {
                    Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
                    String userName = ws.getUserName();
                    String password = ws.getPassword();
                    boolean auto = ws.isAutoLogin();
                    AuthDialog dlg = new AuthDialog(ws);
                    while (connector.isLoginRequired()) {
                        if (!auto) {
                            if (dlg.open() != 0) {
                                connector.terminate();
                                break;
                            }
                            userName = dlg.getUserName();
                            password = dlg.getPassword();
                        }
                        if (connector.login(userName, password)) {
                            ws.setUserName(userName);
                            ws.setPassword(password);
                            ws.setAutoLogin(auto ? true : dlg.getAutologin());
                            try {
                                ws.save(true);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                            break;
                        }
                        auto = false;
                    }
                }
            }
        });
    }
}

