/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.ConnectionAdapter;
import com.moonlit.logfaces.client.dialogs.ConnectionComposite;
import com.moonlit.logfaces.client.dialogs.ConnectionDialog;
import com.moonlit.logfaces.client.net.ConnectionDetails;
import com.moonlit.logfaces.client.net.LfsConnector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.splash.BasicSplashHandler;

public class InteractiveSplashHandlerOriginal
extends BasicSplashHandler
implements ConnectionAdapter {
    private Composite composite;
    private ConnectionDetails connectionDetails;
    private WorkspaceHolder workspaces = WorkspaceHolder.getInstance();
    private boolean connected = false;
    private Throwable failure = null;
    private Shell splash;
    private ThisMonitorPart monitor;

    public InteractiveSplashHandlerOriginal() {
        this.connectionDetails = new ConnectionDetails();
    }

    public void init(Shell splash) {
        super.init(splash);
        this.splash = splash;
        splash.setLayout((Layout)new FillLayout());
        splash.setBackgroundMode(1);
        this.setMessageRect(new Rectangle(150, 140, 300, 50));
        if (Util.isLinux() || Util.isMac()) {
            this.initx();
            return;
        }
        if (!this.loadFromCommandLine()) {
            if (this.connectionDetails.isAutoLogin()) {
                this.activate();
            } else {
                this.createUI();
            }
        }
        while (!this.connected) {
            if (this.failure != null) {
                MessageDialog.openError((Shell)splash, (String)"Connection failed", (String)this.failure.getMessage());
                this.createUI();
                this.failure = null;
            }
            if (splash.getDisplay().readAndDispatch()) continue;
            splash.getDisplay().sleep();
        }
    }

    public void initx() {
        boolean doretry = true;
        IProgressMonitor monitor = this.getBundleProgressMonitor();
        if (!this.loadFromCommandLine() && this.connectionDetails.isAutoLogin()) {
            this.activate();
            doretry = false;
        }
        while (!this.connected) {
            if (doretry) {
                doretry = false;
                ConnectionDialog dlg = new ConnectionDialog(this.splash, this.connectionDetails);
                if (dlg.open() != 0) {
                    this.handleCancel();
                    return;
                }
                this.activate();
            }
            if (this.failure != null) {
                monitor.subTask("");
                MessageDialog.openError((Shell)this.getSplash(), (String)(this.connectionDetails.getLfsHost() + ":" + this.connectionDetails.getLfsPort()), (String)this.failure.getMessage());
                this.failure = null;
                doretry = true;
            }
            if (this.splash.getDisplay().readAndDispatch()) continue;
            this.splash.getDisplay().sleep();
        }
    }

    private void handleCancel() {
        this.getSplash().getDisplay().close();
        System.exit(0);
    }

    private void createUI() {
        this.disposeMonitor();
        this.composite = new ConnectionComposite(this.splash.getShell(), this.connectionDetails, (ConnectionAdapter)this);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.splash.getShell().layout(true, true);
    }

    private void updateUI(final Runnable r) {
        Shell splashShell = this.getSplash();
        if (splashShell == null || splashShell.isDisposed()) {
            return;
        }
        Display display = splashShell.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            StartupThreading.StartupRunnable startupRunnable = new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    r.run();
                }
            };
            display.asyncExec((Runnable)startupRunnable);
        }
    }

    public IProgressMonitor getBundleProgressMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        Composite parent = new Composite((Composite)this.splash, Window.getDefaultOrientation());
        Point size = this.splash.getSize();
        parent.setBounds(new Rectangle(0, 0, size.x, size.y));
        this.monitor = new ThisMonitorPart(parent);
        this.monitor.setSize(size);
        this.monitor.getProgressText().setBounds(new Rectangle(150, 140, 300, 50));
        this.monitor.setBackgroundMode(2);
        this.monitor.setBackgroundImage(this.getSplash().getShell().getBackgroundImage());
        return this.monitor;
    }

    private void disposeMonitor() {
        if (this.monitor != null) {
            this.monitor.getParent().dispose();
            this.monitor = null;
            this.splash.layout(true, true);
        }
    }

    private boolean loadFromCommandLine() {
        String[] args = Platform.getCommandLineArgs();
        if (args == null) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-workspace")) {
                final Workspace ws = this.workspaces.getWorkspace(args[i + 1]);
                if (ws == null) {
                    return false;
                }
                this.workspaces.setCurrentWorkspace(ws);
                this.connectionDetails.setCurrentWorkspace(ws.getName());
                this.connectionDetails.setLfsHost(ws.getServerHost());
                this.connectionDetails.setLfsPort(ws.getServerPort());
                this.connectionDetails.setSsl(ws.isSsl());
                this.connectionDetails.save();
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InteractiveSplashHandlerOriginal.this.getBundleProgressMonitor();
                            InteractiveSplashHandlerOriginal.this.monitor.subTask(String.format("loading '%s'", ws.getName()));
                            LfsConnector.getInstance().connect((IProgressMonitor)InteractiveSplashHandlerOriginal.this.monitor);
                            InteractiveSplashHandlerOriginal.this.connected = true;
                            InteractiveSplashHandlerOriginal.this.splash.getDisplay().wake();
                        }
                        catch (Throwable e) {
                            InteractiveSplashHandlerOriginal.this.splash.getDisplay().wake();
                            InteractiveSplashHandlerOriginal.this.failure = e;
                        }
                    }
                });
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void activate() {
        if (this.composite != null) {
            this.composite.dispose();
            this.splash.layout(true, true);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    InteractiveSplashHandlerOriginal.this.disposeMonitor();
                    InteractiveSplashHandlerOriginal.this.getBundleProgressMonitor();
                    Workspace ws = InteractiveSplashHandlerOriginal.this.workspaces.getWorkspace(InteractiveSplashHandlerOriginal.this.connectionDetails.getCurrentWorkspace());
                    ws.setServerHost(InteractiveSplashHandlerOriginal.this.connectionDetails.getLfsHost());
                    ws.setServerPort(InteractiveSplashHandlerOriginal.this.connectionDetails.getLfsPort());
                    ws.setSsl(InteractiveSplashHandlerOriginal.this.connectionDetails.isSsl());
                    InteractiveSplashHandlerOriginal.this.workspaces.setCurrentWorkspace(ws);
                    LfsConnector.getInstance().connect((IProgressMonitor)InteractiveSplashHandlerOriginal.this.monitor);
                    InteractiveSplashHandlerOriginal.this.connected = true;
                    InteractiveSplashHandlerOriginal.this.splash.getDisplay().wake();
                }
                catch (Throwable e) {
                    InteractiveSplashHandlerOriginal.this.splash.getDisplay().wake();
                    InteractiveSplashHandlerOriginal.this.failure = e;
                }
            }
        });
    }

    @Override
    public void cancel() {
        this.getSplash().getDisplay().close();
        System.exit(0);
    }

    class ThisMonitorPart
    extends ProgressMonitorPart {
        public ThisMonitorPart(Composite parent) {
            super(parent, null);
            this.fProgressIndicator.setVisible(false);
            this.setLayout(null);
        }

        public ProgressIndicator getProgressIndicator() {
            return this.fProgressIndicator;
        }

        public Label getProgressText() {
            return this.fLabel;
        }

        public void beginTask(final String name, final int totalWork) {
            InteractiveSplashHandlerOriginal.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.beginTask(name, totalWork);
                }
            });
        }

        public void done() {
            InteractiveSplashHandlerOriginal.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.done();
                }
            });
        }

        public void internalWorked(final double work) {
            InteractiveSplashHandlerOriginal.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.internalWorked(work);
                }
            });
        }

        public void setFont(final Font font) {
            InteractiveSplashHandlerOriginal.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.setFont(font);
                }
            });
        }

        protected void updateLabel() {
            InteractiveSplashHandlerOriginal.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.updateLabel();
                }
            });
        }
    }
}

