/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageHolder {
    public static final Color BG_DRILL = new Color(null, 0, 80, 160);
    public static final Color FG_DRILL = new Color(null, 255, 255, 50);
    public static final Color BG_DEFAULT = new Color(null, 255, 255, 255);
    public static final Color FG_DEFAULT = new Color(null, 0, 0, 0);
    public static final Color FG_RED = new Color(null, 255, 0, 0);
    public static final Color FG_GREEN = new Color(null, 0, 70, 0);
    private static ImageHolder instance;
    private Map<String, Image> imageCache = Maps.newHashMap();
    private List<Image> productImages = Lists.newArrayList();
    private boolean macos = Util.isMac();

    private ImageHolder() {
    }

    public void dispose() {
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        for (Image image : this.productImages) {
            image.dispose();
        }
    }

    public static ImageHolder getInstance() {
        if (instance == null) {
            instance = new ImageHolder();
        }
        return instance;
    }

    public Image getImage(String id) {
        ImageDescriptor descriptor;
        if (id == null) {
            return null;
        }
        Image image = this.imageCache.get(id);
        if (image == null && (descriptor = MainPlugin.getImageDescriptor(id)) != null) {
            image = MainPlugin.getImageDescriptor(id).createImage();
            this.imageCache.put(id, image);
        }
        return image;
    }

    public Image getButtonImage(String id) {
        return this.macos ? null : this.getImage(id);
    }

    public Image getImage(SliceInfo slice) {
        if (slice.isOfComponents()) {
            return this.getImage("icons/component.gif");
        }
        if (slice.isOfTags()) {
            return this.getImage("icons/tag.gif");
        }
        switch (slice.getType()) {
            case components: {
                return this.getImage("icons/component.gif");
            }
            case tags: {
                return this.getImage("icons/tag.gif");
            }
            case mdc: {
                return this.getImage("icons/prop_ps.gif");
            }
            case regex: {
                return this.getImage("icons/dashboard.gif");
            }
            case integral: {
                return this.getImage("icons/dashboard.gif");
            }
            case attributes: {
                switch (slice.getAttribute()) {
                    case domainName: {
                        return this.getImage("icons/domain.gif");
                    }
                    case hostName: {
                        return this.getImage("icons/host.gif");
                    }
                    case loggerName: {
                        return this.getImage("icons/class.gif");
                    }
                    case loggerLevel: {
                        return this.getImage("icons/level_debug3.gif");
                    }
                    case threadName: {
                        return this.getImage("icons/trace_start.gif");
                    }
                    case thrown: {
                        return this.getImage("icons/exclude.gif");
                    }
                    case throwableInfo: {
                        return this.getImage("icons/exclude.gif");
                    }
                }
            }
        }
        return this.getImage("icons/prop_ps.gif");
    }

    public ImageDescriptor getImageDescriptor(SliceInfo slice) {
        if (slice.isOfComponents()) {
            return MainPlugin.getImageDescriptor("icons/component.gif");
        }
        if (slice.isOfTags()) {
            return MainPlugin.getImageDescriptor("icons/tag.gif");
        }
        switch (slice.getType()) {
            case components: {
                return MainPlugin.getImageDescriptor("icons/component.gif");
            }
            case tags: {
                return MainPlugin.getImageDescriptor("icons/tag.gif");
            }
            case mdc: {
                return MainPlugin.getImageDescriptor("icons/prop_ps.gif");
            }
            case regex: {
                return MainPlugin.getImageDescriptor("icons/dashboard.gif");
            }
            case integral: {
                return MainPlugin.getImageDescriptor("icons/or.gif");
            }
            case attributes: {
                switch (slice.getAttribute()) {
                    case domainName: {
                        return MainPlugin.getImageDescriptor("icons/domain.gif");
                    }
                    case hostName: {
                        return MainPlugin.getImageDescriptor("icons/host.gif");
                    }
                    case loggerName: {
                        return MainPlugin.getImageDescriptor("icons/class.gif");
                    }
                    case loggerLevel: {
                        return MainPlugin.getImageDescriptor("icons/level_debug3.gif");
                    }
                    case threadName: {
                        return MainPlugin.getImageDescriptor("icons/trace_start.gif");
                    }
                    case thrown: {
                        return MainPlugin.getImageDescriptor("icons/exclude.gif");
                    }
                    case throwableInfo: {
                        return MainPlugin.getImageDescriptor("icons/exclude.gif");
                    }
                }
            }
        }
        return MainPlugin.getImageDescriptor("icons/prop_ps.gif");
    }

    public Image getImageExternal(String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            Image image = new Image((Device)Display.getDefault(), fileName);
            this.imageCache.put(fileName, image);
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateProductShellImages(Shell shell) {
        String[] split;
        IProduct product;
        if (this.productImages.isEmpty() && (product = Platform.getProduct()) != null && (split = StringUtils.split((String)product.getProperty("windowImages"), (String)",")) != null) {
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)product.getDefiningBundle().getSymbolicName(), (String)string);
                this.productImages.add(descriptor.createImage(true));
                ++n2;
            }
        }
        shell.setImages(this.productImages.toArray(new Image[this.productImages.size()]));
    }
}

