/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.server.conf.MdcMap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;

public class Columns {
    public static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");
    public static final SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final String QUERY_HEADERS = "lfs_headers";
    public static final int COL_SEVERITY = 0;
    public static final int COL_TAG = 1;
    public static final int COL_DATE = 2;
    public static final int COL_TIME = 3;
    public static final int COL_HOST = 4;
    public static final int COL_DOMAIN = 5;
    public static final int COL_COMPONENT = 6;
    public static final int COL_LOGGER = 7;
    public static final int COL_THREAD = 8;
    public static final int COL_LOCATION = 9;
    public static final int COL_THROWN = 10;
    public static final int COL_NDC = 11;
    public static final int COL_MESSAGE = 12;
    public static final int DEFAULT_COLUMN_MASK = 160897;
    public static String[] COL_NAME = new String[]{"", "Tags", "Date", "Time", "Host", "Domain", "Component", "Logger", "Thread", "Location", "(!)", "NDC", "Message"};

    public static LogHeaderInfoVO[] makeDefaultHeaders() {
        List<String> visible = Columns.getDefaultHeaders();
        LogHeaderInfoVO[] headerInfo = new LogHeaderInfoVO[Columns.getNofColumns()];
        headerInfo[0] = new LogHeaderInfoVO(COL_NAME[0], 30, visible.contains(COL_NAME[0]));
        headerInfo[1] = new LogHeaderInfoVO(COL_NAME[1], 100, visible.contains(COL_NAME[1]));
        headerInfo[2] = new LogHeaderInfoVO(COL_NAME[2], 100, visible.contains(COL_NAME[2]));
        headerInfo[3] = new LogHeaderInfoVO(COL_NAME[3], 100, visible.contains(COL_NAME[3]));
        headerInfo[4] = new LogHeaderInfoVO(COL_NAME[4], 100, visible.contains(COL_NAME[4]));
        headerInfo[5] = new LogHeaderInfoVO(COL_NAME[5], 100, visible.contains(COL_NAME[5]));
        headerInfo[6] = new LogHeaderInfoVO(COL_NAME[6], 150, visible.contains(COL_NAME[6]));
        headerInfo[7] = new LogHeaderInfoVO(COL_NAME[7], 150, visible.contains(COL_NAME[7]));
        headerInfo[8] = new LogHeaderInfoVO(COL_NAME[8], 100, visible.contains(COL_NAME[8]));
        headerInfo[9] = new LogHeaderInfoVO(COL_NAME[9], 100, visible.contains(COL_NAME[9]));
        headerInfo[10] = new LogHeaderInfoVO(COL_NAME[10], 50, visible.contains(COL_NAME[10]));
        headerInfo[11] = new LogHeaderInfoVO(COL_NAME[11], 100, visible.contains(COL_NAME[11]));
        headerInfo[12] = new LogHeaderInfoVO(COL_NAME[12], 400, visible.contains(COL_NAME[12]));
        int i = 0;
        while (i < MdcMap.getSize()) {
            String name;
            headerInfo[12 + i + 1] = new LogHeaderInfoVO(name, 100, !StringUtils.isEmpty((CharSequence)(name = MdcMap.getName((int)i))) && visible.contains(name));
            ++i;
        }
        return headerInfo;
    }

    public static LogHeaderInfoVO[] makeHeaders(List<String> names) {
        LogHeaderInfoVO[] headers;
        LogHeaderInfoVO[] logHeaderInfoVOArray = headers = Columns.makeDefaultHeaders();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            LogHeaderInfoVO header = logHeaderInfoVOArray[n2];
            header.setVisible(names.contains(header.getName()));
            ++n2;
        }
        return headers;
    }

    public static void updateDefaultHeaders(LogHeaderInfoVO[] headers) {
        ArrayList<String> list = new ArrayList<String>();
        LogHeaderInfoVO[] logHeaderInfoVOArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            LogHeaderInfoVO header = logHeaderInfoVOArray[n2];
            if (header.isVisible()) {
                list.add(header.getName());
            }
            ++n2;
        }
        Application.getPrefs().put(QUERY_HEADERS, StringUtils.join(list, (String)","));
    }

    public static List<String> getDefaultHeaders() {
        String defaults = ",Time,Host,Domain,Logger,Thread,(!),Message";
        String string = Application.getPrefs().get(QUERY_HEADERS, defaults);
        return Lists.newArrayList((Object[])StringUtils.split((String)string, (String)","));
    }

    public static void setDefaultHeaders(String headers) {
        Application.getPrefs().put(QUERY_HEADERS, headers);
    }

    public static int[] getColumnOrder() {
        int nof = Columns.getNofColumns();
        int[] order = new int[nof];
        int i = 0;
        while (i < 12) {
            order[i] = i;
            ++i;
        }
        i = 12;
        while (i < nof) {
            order[i] = i + 1;
            ++i;
        }
        order[nof - 1] = 12;
        return order;
    }

    public static int name2column(String name) {
        int i = 0;
        while (i <= 12) {
            if (COL_NAME[i].equals(name)) {
                return i;
            }
            ++i;
        }
        int mdcIndex = MdcMap.getKey((String)name);
        if (mdcIndex >= 0) {
            return 12 + mdcIndex + 1;
        }
        return -1;
    }

    public static String column2string(int column) {
        if (Columns.isMdcColumn(column)) {
            return String.format("%s", MdcMap.getName((int)(column - 12 - 1)));
        }
        switch (column) {
            case 0: {
                return "Level";
            }
            case 1: {
                return "Tag";
            }
            case 2: {
                return "Date";
            }
            case 3: {
                return "Time";
            }
            case 5: {
                return "Domain";
            }
            case 6: {
                return "Component";
            }
            case 4: {
                return "Host";
            }
            case 10: {
                return "Thrown";
            }
            case 8: {
                return "Thread";
            }
            case 7: {
                return "Logger";
            }
            case 9: {
                return "Location";
            }
            case 12: {
                return "Message";
            }
            case 11: {
                return "NDC";
            }
        }
        return "";
    }

    public static String column2category(int column) {
        if (Columns.isMdcColumn(column)) {
            return String.format("%s", MdcMap.getName((int)(column - 12 - 1)));
        }
        switch (column) {
            case 5: {
                return "Applications";
            }
            case 6: {
                return "Components";
            }
            case 4: {
                return "Hosts";
            }
            case 0: {
                return "Levels";
            }
            case 10: {
                return "Exceptions";
            }
            case 1: {
                return "Tags";
            }
            case 8: {
                return "Threads";
            }
            case 7: {
                return "Loggers";
            }
        }
        return "";
    }

    public static ImageDescriptor column2image(int column) {
        switch (column) {
            case 5: {
                return MainPlugin.getImageDescriptor("icons/domain.gif");
            }
            case 6: {
                return MainPlugin.getImageDescriptor("icons/component.gif");
            }
            case 4: {
                return MainPlugin.getImageDescriptor("icons/host.gif");
            }
            case 0: {
                return MainPlugin.getImageDescriptor("icons/level_debug3.gif");
            }
            case 10: {
                return MainPlugin.getImageDescriptor("icons/exclude.gif");
            }
            case 1: {
                return MainPlugin.getImageDescriptor("icons/tag.gif");
            }
            case 8: {
                return MainPlugin.getImageDescriptor("icons/trace_start.gif");
            }
            case 7: {
                return MainPlugin.getImageDescriptor("icons/class.gif");
            }
        }
        return MainPlugin.getImageDescriptor("icons/prop_ps.gif");
    }

    public static boolean isMdcColumn(int column) {
        return column > 12;
    }

    public static int mdc2column(String name) {
        int key = MdcMap.getKey((String)name);
        if (key < 0) {
            return key;
        }
        return 12 + key + 1;
    }

    public static String column2mdc(int column) {
        if (!Columns.isMdcColumn(column)) {
            return "";
        }
        return MdcMap.getName((int)(column - 12 - 1));
    }

    public static int getNofColumns() {
        return 12 + MdcMap.getSize() + 1;
    }

    public static String getDateStamp(long time) {
        Date date = new Date(time);
        return dateFormat.format(date);
    }

    public static String getTimeStamp(long time) {
        return timeFormat.format(new Date(time));
    }
}

