/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ApplicationActionBarAdvisor;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.actions.FastFetchAction;
import com.moonlit.logfaces.client.actions.FileIndexingAction;
import com.moonlit.logfaces.client.dialogs.LicenseDialog;
import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.embedded.LicenseManager;
import com.moonlit.logfaces.client.jobs.FetchQueryJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.ChoiceAdapterFactory;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.model.ChoiceModelItem;
import com.moonlit.logfaces.client.model.ContextAdapterFactory;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.RepositoryAdapterFactory;
import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements IEclipsePreferences.IPreferenceChangeListener {
    private boolean useTray;
    private TrayItem trayItem;
    private Image trayImage;
    private ApplicationActionBarAdvisor actionBarAdvisor;
    private IEclipsePreferences prefs = Application.getPrefs();
    private static final Logger log = LogManager.getLogger(ApplicationWorkbenchWindowAdvisor.class);

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        LfsEventBus.getInstance().register((Object)this);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.actionBarAdvisor = new ApplicationActionBarAdvisor(configurer);
        return this.actionBarAdvisor;
    }

    public void preWindowOpen() {
        try {
            if (Application.isServerMode() && !this.verifyLicense()) {
                log.warn("license not valid, exiting");
                System.exit(0);
            }
            this.useTray = Util.isLinux() ? false : this.prefs.getBoolean("minimize_to_tray", true);
            this.prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.setShowCoolBar(true);
            configurer.setShowStatusLine(true);
            configurer.setShowPerspectiveBar(false);
            configurer.setShowProgressIndicator(true);
            configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
            configurer.configureEditorAreaDropListener((DropTargetListener)new Dropper());
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)new ContextAdapterFactory(), ContextElement.class);
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)new RepositoryAdapterFactory(), RepositoryElement.class);
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)new ChoiceAdapterFactory(), ChoiceModel.class);
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)new ChoiceAdapterFactory(), ChoiceModelItem.class);
            PlatformUI.getPreferenceStore().setValue("SHOW_MEMORY_MONITOR", true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError(null, (String)"Internal error", (String)("Failed to load workspace: " + e.getMessage()));
        }
    }

    public void postWindowOpen() {
        try {
            IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
            this.trayItem = this.initTaskItem(window);
            if (this.trayItem != null) {
                this.hookPopupMenu(window);
                this.hookMinimize(window);
            }
            if (this.prefs.getBoolean("com.moonlit.lfc.firstTime", true)) {
                this.prefs.putBoolean("com.moonlit.lfc.firstTime", false);
                this.positionMainWindow(window);
            }
            WorkspaceHolder.getInstance().initialize();
            new FileIndexingAction(false).run();
            this.processCommandLine();
            if (Application.isServerMode()) {
                PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
                pm.remove("com.moonlit.logfaces.client.prefs.query");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void positionMainWindow(IWorkbenchWindow window) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Shell shell = Application.getShell();
                    Monitor primary = shell.getDisplay().getPrimaryMonitor();
                    Rectangle bounds = primary.getBounds();
                    shell.setSize(bounds.width - bounds.width / 10, bounds.height - bounds.height / 6);
                    Rectangle rect = shell.getBounds();
                    int x = bounds.x + (bounds.width - rect.width) / 2;
                    int y = bounds.y + (bounds.height - rect.height) / 2;
                    shell.setLocation(x, y);
                    log.info("main window is positioned in display center");
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
        });
    }

    private boolean verifyLicense() {
        while (true) {
            try {
                LicenseManager.getInstance().verifyLicense();
            }
            catch (Exception e1) {
                if (!MessageDialog.openQuestion(null, (String)"License", (String)"Currently installed license is not valid or expired. Would you like to install new license now? ")) {
                    return false;
                }
                LicenseDialog ld = new LicenseDialog();
                ld.open();
                continue;
            }
            break;
        }
        try {
            if (LicenseManager.getInstance().isTrial() && Application.getPrefs().getBoolean("first_time_trial", true)) {
                Application.getPrefs().putBoolean("first_time_trial", false);
                Application.getPrefs().flush();
                MessageDialog.openInformation(null, (String)"One time notice", (String)"Thank you for evaluating logFaces!\n\nYour free trial license is activated for 10 days.\nHave fun!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void processCommandLine() {
        String[] args = Platform.getCommandLineArgs();
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-query")) {
                QueryVO vo = QueryVO.fromCommandLine(Utils.commandLine2map(args[i + 1]));
                QueryDataFetcher fetcher = new QueryDataFetcher(vo, false);
                FetchQueryJob job = new FetchQueryJob(fetcher);
                job.setUser(true);
                job.schedule();
                return;
            }
            ++i;
        }
    }

    private void hookMinimize(final IWorkbenchWindow window) {
        window.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                if (ApplicationWorkbenchWindowAdvisor.this.useTray) {
                    window.getShell().setVisible(false);
                    log.info("main shell iconified");
                }
            }

            public void shellDeiconified(ShellEvent e) {
                log.info("main shell de-iconified");
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                Shell shell = window.getShell();
                if (!shell.isVisible()) {
                    shell.setMinimized(false);
                    window.getShell().requestLayout();
                    shell.setVisible(true);
                }
                shell.setFocus();
            }
        });
    }

    private void hookPopupMenu(final IWorkbenchWindow window) {
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                MenuManager trayMenu = new MenuManager();
                Menu menu = trayMenu.createContextMenu((Control)window.getShell());
                ApplicationWorkbenchWindowAdvisor.this.actionBarAdvisor.fillTrayItem((IMenuManager)trayMenu);
                menu.setVisible(true);
            }
        });
    }

    private TrayItem initTaskItem(IWorkbenchWindow window) {
        if (!this.useTray || Util.isLinux()) {
            return null;
        }
        Tray tray = window.getShell().getDisplay().getSystemTray();
        if (tray == null) {
            return null;
        }
        this.trayItem = new TrayItem(tray, 0);
        this.trayImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.moonlit.logfaces.client.plugin", (String)"icons/lf32x.png").createImage();
        this.trayItem.setImage(this.trayImage);
        Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
        this.trayItem.setToolTipText(ws != null ? ws.getName() : "logFaces client");
        return this.trayItem;
    }

    private void restoreEditors() {
        try {
            if (!LfsConnector.getInstance().isConnected()) {
                return;
            }
            log.info("restoring real-time perspectives");
            IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
            IWorkbenchPage page = window.getActivePage();
            for (PerspectiveVO vo : LogPerspectivesModel.getInstance().listEntries()) {
                try {
                    if (!vo.isOpened() || Utils.isParametrized(vo.getCriteria())) continue;
                    page.openEditor((IEditorInput)new LogEditorInput(vo), "com.moonlit.logfaces.client.LogEditor");
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.WORKSPACE_LOADED)) {
            Workspace workspace = WorkspaceHolder.getInstance().getCurrentWorkspace();
            if (workspace != null) {
                String title = String.format("%s (%s)", workspace.getName(), workspace.getServerHost());
                IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
                configurer.setTitle(title);
                log.info("workspace '{}' is loaded", (Object)title);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ApplicationWorkbenchWindowAdvisor.this.restoreEditors();
                }
            });
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("minimize_to_tray")) {
            if (Util.isLinux()) {
                return;
            }
            this.useTray = this.prefs.getBoolean("minimize_to_tray", true);
            if (this.useTray) {
                IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
                this.trayItem = this.initTaskItem(window);
                if (this.trayItem != null) {
                    this.hookPopupMenu(window);
                    this.hookMinimize(window);
                }
            } else if (this.trayItem != null) {
                this.trayItem.dispose();
                this.trayItem = null;
            }
        }
    }

    class Dropper
    extends DropTargetAdapter {
        Dropper() {
        }

        public void drop(DropTargetEvent event) {
            if (!(event.data instanceof String[])) {
                return;
            }
            try {
                String[] names;
                String[] stringArray = names = (String[])event.data;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    File file = new File(name);
                    new FastFetchAction(file).run();
                    ++n2;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
            super.dragEnter(event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }
}

