/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ApplicationWorkbenchWindowAdvisor;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.ConnectionDialog2;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String PERSPECTIVE_ID = "com.moonlit.logfaces.client.plugin.perspective";
    private static final Logger log = LogManager.getLogger(ApplicationWorkbenchAdvisor.class);

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
    }

    public void preStartup() {
        if (LfsConnector.getInstance().isConnected()) {
            return;
        }
        Application.getContext().applicationRunning();
        ConnectionDialog2 dialog = new ConnectionDialog2();
        dialog.setWorkspace(this.args2workspace());
        if (dialog.open() != 0) {
            log.info("login canceled, exiting");
            System.exit(0);
        }
    }

    private Workspace args2workspace() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-workspace")) {
                String name = args[i + 1];
                try {
                    File file = new File(name);
                    if (file.exists()) {
                        return WorkspaceHolder.getInstance().addWorkspace(file);
                    }
                }
                catch (Exception e) {
                    log.info("failed loading workspace from file '{}', trying the workspace by name", (Object)name);
                }
                return WorkspaceHolder.getInstance().getWorkspace(name);
            }
            ++i;
        }
        return null;
    }

    public void postStartup() {
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            log.info("workbench started");
        }
    }

    public boolean preShutdown() {
        try {
            Utils.saveLogEditorStates();
            WorkspaceHolder.getInstance().save();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

