/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.actions.AboutAction;
import com.moonlit.logfaces.client.actions.CloseAllEditorsAction;
import com.moonlit.logfaces.client.actions.CloseAllViewsAction;
import com.moonlit.logfaces.client.actions.EscapeAction;
import com.moonlit.logfaces.client.actions.ExportWorkspaceAction;
import com.moonlit.logfaces.client.actions.FastFetchAction;
import com.moonlit.logfaces.client.actions.FileIndexingAction;
import com.moonlit.logfaces.client.actions.FindAction;
import com.moonlit.logfaces.client.actions.FontDownAction;
import com.moonlit.logfaces.client.actions.FontUpAction;
import com.moonlit.logfaces.client.actions.ImportWorkspaceAction;
import com.moonlit.logfaces.client.actions.LicenseAction;
import com.moonlit.logfaces.client.actions.ListDashboardsAction;
import com.moonlit.logfaces.client.actions.ListPerspectivesAction;
import com.moonlit.logfaces.client.actions.ListQueriesAction;
import com.moonlit.logfaces.client.actions.ListRepositoryAction;
import com.moonlit.logfaces.client.actions.LoadSharedWorkspaceAction;
import com.moonlit.logfaces.client.actions.NewWorkspaceAction;
import com.moonlit.logfaces.client.actions.OpenPatternsEditorAction;
import com.moonlit.logfaces.client.actions.ParseLogFileAction;
import com.moonlit.logfaces.client.actions.ShareWorkspaceAction;
import com.moonlit.logfaces.client.actions.ShowAdminConsoleAction;
import com.moonlit.logfaces.client.actions.ShowAlertsAction;
import com.moonlit.logfaces.client.actions.ShowComponentsAction;
import com.moonlit.logfaces.client.actions.ShowCountersAction;
import com.moonlit.logfaces.client.actions.ShowGisAction;
import com.moonlit.logfaces.client.actions.ShowHostsAction;
import com.moonlit.logfaces.client.actions.ShowRegexTesterAction;
import com.moonlit.logfaces.client.actions.ShowRepositoryAction;
import com.moonlit.logfaces.client.actions.ShowSlicesAction;
import com.moonlit.logfaces.client.actions.ShowStatsAction;
import com.moonlit.logfaces.client.actions.ShowSupportAction;
import com.moonlit.logfaces.client.actions.StatusLineContribution;
import com.moonlit.logfaces.client.actions.SwitchWorkspaceAction;
import com.moonlit.logfaces.client.actions.TidyWorkspacesAction;
import com.moonlit.logfaces.client.actions.UpdateAction;
import com.moonlit.logfaces.client.editors.DashboardEditor;
import com.moonlit.logfaces.client.jobs.DatabaseSizeJob;
import com.moonlit.logfaces.client.model.ParsersModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.server.util.LfsEventBus;
import com.moonlit.logfaces.server.util.Revision;
import com.moonlit.logfaces.server.vo.AlertVO;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor
implements IEclipsePreferences.IPreferenceChangeListener,
IPartListener {
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction prefAction;
    private Action showGisAction;
    private Action showQueriesAction;
    private Action showPerspectivesAction;
    private Action showDashboardAction;
    private Action searchAction;
    private Action repoActions;
    private Action showStatsAction;
    private Action showCountersAction;
    private Action showAlertsAction;
    private Action showSlicesAction;
    private Action licenseAction;
    private Action indexingAction;
    private Action fontUpAction;
    private Action fontDownAction;
    private Action findAction;
    private Action updateAction;
    private Action showSupportAction;
    private Action showAdminConsoleAction;
    private Action closeAllEditorsAction;
    private Action closeAllViewsAction;
    private Action importWorkspaceAction;
    private Action exportWorkspaceAction;
    private Action shareWorkspaceAction;
    private Action loadWorkspaceAction;
    private Action switchWorkspaceAction;
    private Action newWorkspaceAction;
    private Action tidyWorkspacesAction;
    private Action parseLogFileAction;
    private Action openPatternsAction;
    private Action regexTesterAction;
    private Action aboutAction;
    private StatusLineContribution statusContribution;
    private StatusLineContribution alertContribution;
    private StatusLineContribution dbContribution;
    private LfsConnector connector = LfsConnector.getInstance();
    private static final Logger log = LogManager.getLogger(ApplicationActionBarAdvisor.class);

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        LfsEventBus.getInstance().register((Object)this);
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    protected void makeActions(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener)this);
        try {
            this.exitAction = ActionFactory.QUIT.create(window);
            this.register((IAction)this.exitAction);
            this.register((IAction)new EscapeAction());
            this.findAction = new FindAction();
            this.register((IAction)new FindAction());
            this.fontUpAction = new FontUpAction();
            this.register((IAction)this.fontUpAction);
            this.fontDownAction = new FontDownAction();
            this.register((IAction)this.fontDownAction);
            this.prefAction = ActionFactory.PREFERENCES.create(window);
            this.prefAction.setText("Preferences...");
            this.prefAction.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/preferences.gif"));
            this.register((IAction)this.prefAction);
            this.aboutAction = new AboutAction();
            this.aboutAction.setImageDescriptor(MainPlugin.getImageDescriptor("icons/lf16.png"));
            this.register((IAction)this.aboutAction);
            this.updateAction = new UpdateAction();
            this.register((IAction)this.updateAction);
            this.showSupportAction = new ShowSupportAction();
            this.register((IAction)this.showSupportAction);
            this.indexingAction = new FileIndexingAction(true);
            this.register((IAction)this.indexingAction);
            if (Application.isServerMode()) {
                this.licenseAction = new LicenseAction();
                this.register((IAction)this.licenseAction);
            }
            if (!Application.isServerMode()) {
                this.showAdminConsoleAction = new ShowAdminConsoleAction();
                this.register((IAction)this.showAdminConsoleAction);
                this.showCountersAction = new ShowCountersAction();
                this.register((IAction)this.showCountersAction);
                if (Compatibility.canUseAlerts()) {
                    this.showAlertsAction = new ShowAlertsAction();
                    this.register((IAction)this.showAlertsAction);
                }
                if (ConnectionProfile.getInstance().isDatabaseEnabled()) {
                    this.showQueriesAction = new ListQueriesAction();
                    this.register((IAction)this.showQueriesAction);
                    this.showDashboardAction = new ListDashboardsAction();
                    this.register((IAction)this.showDashboardAction);
                    this.searchAction = new FastFetchAction();
                    this.register((IAction)this.searchAction);
                    if (Util.isWindows()) {
                        this.showGisAction = new ShowGisAction();
                        this.register((IAction)this.showGisAction);
                    }
                }
            }
            this.showPerspectivesAction = new ListPerspectivesAction();
            this.register((IAction)this.showPerspectivesAction);
            if (ConnectionProfile.getInstance().isDatabaseEnabled()) {
                this.repoActions = new ListRepositoryAction();
                this.register((IAction)this.repoActions);
            }
            this.showStatsAction = new ShowStatsAction();
            this.register((IAction)this.showStatsAction);
            this.showSlicesAction = new ShowSlicesAction();
            this.register((IAction)this.showSlicesAction);
            this.closeAllEditorsAction = new CloseAllEditorsAction();
            this.register((IAction)this.closeAllEditorsAction);
            this.closeAllViewsAction = new CloseAllViewsAction();
            this.register((IAction)this.closeAllViewsAction);
            this.importWorkspaceAction = new ImportWorkspaceAction();
            this.register((IAction)this.importWorkspaceAction);
            this.exportWorkspaceAction = new ExportWorkspaceAction();
            this.register((IAction)this.exportWorkspaceAction);
            if (!Application.isServerMode()) {
                this.shareWorkspaceAction = new ShareWorkspaceAction();
                this.register((IAction)this.shareWorkspaceAction);
                this.loadWorkspaceAction = new LoadSharedWorkspaceAction();
                this.register((IAction)this.loadWorkspaceAction);
            }
            this.parseLogFileAction = new ParseLogFileAction();
            this.parseLogFileAction.setEnabled(ParsersModel.getInstance().size() > 0);
            this.register((IAction)this.parseLogFileAction);
            this.openPatternsAction = new OpenPatternsEditorAction();
            this.register((IAction)this.openPatternsAction);
            this.regexTesterAction = new ShowRegexTesterAction();
            this.register((IAction)this.regexTesterAction);
            if (!Application.isServerMode()) {
                this.switchWorkspaceAction = new SwitchWorkspaceAction();
                this.register((IAction)this.switchWorkspaceAction);
                this.newWorkspaceAction = new NewWorkspaceAction();
                this.register((IAction)this.newWorkspaceAction);
                this.tidyWorkspacesAction = new TidyWorkspacesAction();
                this.register((IAction)this.tidyWorkspacesAction);
            }
            this.statusContribution = new StatusLineContribution("statusline", 100);
            this.statusContribution.addListener(4, event -> this.aboutAction.run());
            this.updateStatusContribution();
            if (!Application.isServerMode() && ConnectionProfile.getInstance().isDatabaseEnabled()) {
                this.dbContribution = new StatusLineContribution("dbsize", 50);
                this.dbContribution.addListener(4, event -> this.updateDbContribution());
                this.dbContribution.setTooltip("click to update");
                this.dbContribution.setText("click to update");
                this.dbContribution.setImage(ImageHolder.getInstance().getImage("icons/database.gif"));
            }
            if (!Application.isServerMode() && Compatibility.canUseAlerts()) {
                this.alertContribution = new StatusLineContribution("alarms", 20);
                this.alertContribution.addListener(4, event -> {
                    if (Application.getPrefs().getBoolean("show_alerts", true)) {
                        this.showAlertsAction.run();
                    }
                });
                this.alertContribution.setTooltip("currently outstanding alarms");
                this.alertContribution.setText(" ");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        try {
            MenuManager fileMenu = new MenuManager("&File", "file");
            MenuManager viewMenu = new MenuManager("&View", "view");
            MenuManager toolsMenu = new MenuManager("&Tools", "tools");
            MenuManager helpMenu = new MenuManager("&Help", "help");
            MenuManager windowsMenu = new MenuManager("&Window", "window");
            if (!Application.isServerMode()) {
                fileMenu.add((IAction)this.newWorkspaceAction);
                fileMenu.add((IAction)this.tidyWorkspacesAction);
                fileMenu.add((IAction)this.switchWorkspaceAction);
                fileMenu.add((IContributionItem)new Separator());
            }
            fileMenu.add((IAction)this.importWorkspaceAction);
            fileMenu.add((IAction)this.exportWorkspaceAction);
            if (!Application.isServerMode()) {
                fileMenu.add((IContributionItem)new Separator());
                fileMenu.add((IAction)this.shareWorkspaceAction);
                fileMenu.add((IAction)this.loadWorkspaceAction);
                fileMenu.add((IContributionItem)new Separator());
            }
            fileMenu.add((IContributionItem)new Separator());
            ActionContributionItem prefItem = new ActionContributionItem((IAction)this.prefAction);
            prefItem.setVisible(true);
            fileMenu.add((IContributionItem)prefItem);
            fileMenu.add((IContributionItem)new Separator());
            ActionContributionItem exitItem = new ActionContributionItem((IAction)this.exitAction);
            exitItem.setVisible(true);
            fileMenu.add((IContributionItem)exitItem);
            if (!Util.isLinux()) {
                viewMenu.add((IAction)this.fontUpAction);
                viewMenu.add((IAction)this.fontDownAction);
                viewMenu.add((IContributionItem)new Separator());
            }
            viewMenu.add((IAction)this.findAction);
            toolsMenu.add((IAction)this.indexingAction);
            toolsMenu.add((IAction)this.openPatternsAction);
            toolsMenu.add((IAction)this.regexTesterAction);
            toolsMenu.add((IContributionItem)new Separator());
            toolsMenu.add((IAction)this.parseLogFileAction);
            toolsMenu.add((IContributionItem)new Separator());
            if (!Application.isServerMode()) {
                toolsMenu.add((IContributionItem)new Separator());
                toolsMenu.add((IAction)this.showAdminConsoleAction);
            }
            helpMenu.add((IContributionItem)new GroupMarker("additions"));
            helpMenu.add((IAction)this.updateAction);
            helpMenu.add((IAction)this.showSupportAction);
            helpMenu.add((IContributionItem)new Separator());
            if (Application.isServerMode()) {
                helpMenu.add((IAction)this.licenseAction);
            }
            ActionContributionItem aboutItem = new ActionContributionItem((IAction)this.aboutAction);
            aboutItem.setVisible(true);
            helpMenu.add((IContributionItem)aboutItem);
            if (this.showAlertsAction != null) {
                windowsMenu.add((IAction)this.showAlertsAction);
                windowsMenu.add((IContributionItem)new Separator());
            }
            if (ConnectionProfile.getInstance().isDatabaseEnabled()) {
                windowsMenu.add((IAction)new ShowRepositoryAction());
                windowsMenu.add((IAction)new ShowHostsAction());
                windowsMenu.add((IAction)new ShowComponentsAction());
                windowsMenu.add((IContributionItem)new Separator());
            }
            windowsMenu.add((IAction)this.showSlicesAction);
            windowsMenu.add((IAction)this.showStatsAction);
            if (!Application.isServerMode()) {
                windowsMenu.add((IAction)this.showCountersAction);
            }
            windowsMenu.add((IContributionItem)new Separator());
            windowsMenu.add((IAction)this.closeAllViewsAction);
            windowsMenu.add((IAction)this.closeAllEditorsAction);
            menuBar.add((IContributionItem)fileMenu);
            menuBar.add((IContributionItem)viewMenu);
            menuBar.add((IContributionItem)new GroupMarker("additions"));
            menuBar.add((IContributionItem)toolsMenu);
            menuBar.add((IContributionItem)windowsMenu);
            menuBar.add((IContributionItem)helpMenu);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        try {
            ToolBarManager toolbar = new ToolBarManager(coolBar.getStyle() | 0x20000);
            this.addContribution(this.showPerspectivesAction, toolbar);
            this.addContribution(this.showQueriesAction, toolbar);
            this.addContribution(this.showDashboardAction, toolbar);
            this.addContribution(this.repoActions, toolbar);
            this.addContribution(this.searchAction, toolbar);
            this.addContribution(this.showStatsAction, toolbar);
            this.addContribution(this.showSlicesAction, toolbar);
            this.addContribution(this.showGisAction, toolbar);
            toolbar.add((IContributionItem)new Separator("additions"));
            this.addContribution(this.closeAllEditorsAction, toolbar);
            this.addContribution(this.closeAllViewsAction, toolbar);
            coolBar.add((IToolBarManager)toolbar);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void fillTrayItem(IMenuManager trayItem) {
        try {
            trayItem.add((IAction)this.aboutAction);
            trayItem.add((IAction)this.exitAction);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addContribution(Action action, ToolBarManager toolbar) {
        if (action != null) {
            ActionContributionItem contr = new ActionContributionItem((IAction)action);
            contr.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            toolbar.add((IContributionItem)contr);
        }
    }

    private void updateStatusContribution() {
        try {
            boolean connected = this.connector.isConnected();
            if (!connected) {
                this.statusContribution.setText("not connected");
                this.statusContribution.setImage(ImageHolder.getInstance().getImage("icons/message_error.gif"));
                return;
            }
            Map<String, String> lic = ConnectionProfile.getInstance().getLicenseInfo();
            if (lic == null) {
                return;
            }
            String text = "";
            IEclipsePreferences prefs = Application.getPrefs();
            Revision revision = ConnectionProfile.getInstance().getRevision();
            if (!prefs.getBoolean("server_mode", false)) {
                text = String.format("%s:%d, v%s (%s, %s)", prefs.get("lfs_host_name", "localhost"), prefs.getInt("lfs_port_num", 8050), revision, lic.get("licenseType"), lic.get("licenseHolder"));
            } else {
                if (prefs.getBoolean("tcp_enabled", false)) {
                    text = String.format("listening tcp:%d", prefs.getInt("tcp_port_num", 55200));
                }
                if (prefs.getBoolean("udp_enabled", false)) {
                    text = String.format("%s udp:%d", text, prefs.getInt("udp_port_num", 55201));
                }
                text = String.format("%s, v%s (%s, %s)", text, revision, lic.get("licenseType"), lic.get("licenseHolder"));
            }
            Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
            this.statusContribution.setText(text);
            this.statusContribution.setImage(ImageHolder.getInstance().getImage(ws.isSsl() ? "icons/lock.gif" : "/icons/connection.gif"));
            this.statusContribution.setTooltip(text);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void updateDbContribution() {
        if (this.dbContribution != null) {
            new DatabaseSizeJob(this.dbContribution).schedule();
        }
    }

    private void updateAlertsContribution() {
        if (this.alertContribution == null) {
            return;
        }
        if (!Application.getPrefs().getBoolean("show_alerts", true)) {
            this.alertContribution.stopBlink(" ", null);
            ((ShowAlertsAction)this.showAlertsAction).hide();
            return;
        }
        boolean connected = this.connector.isConnected();
        if (!connected) {
            this.alertContribution.stopBlink(" ", null);
            ((ShowAlertsAction)this.showAlertsAction).hide();
            return;
        }
        List<AlertVO> alerts = this.connector.getAlerts();
        if (alerts.isEmpty()) {
            this.alertContribution.stopBlink(" ", null);
            ((ShowAlertsAction)this.showAlertsAction).hide();
            return;
        }
        this.alertContribution.blink("server alerts", ImageHolder.getInstance().getImage("icons/task_warning_misc.gif"));
    }

    private void enableDashboardSensitiveActions() {
        boolean editors;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IWorkbenchPart part = page.getActivePart();
        boolean dasboards = part instanceof DashboardEditor;
        boolean bl = editors = page != null && page.getEditorReferences().length > 0;
        if (this.showSlicesAction != null) {
            this.showSlicesAction.setEnabled(!dasboards && editors);
        }
        if (this.showGisAction != null) {
            this.showGisAction.setEnabled(!dasboards && editors);
        }
        if (this.showStatsAction != null) {
            this.showStatsAction.setEnabled(!dasboards && editors);
        }
        if (this.repoActions != null) {
            this.repoActions.setEnabled(!dasboards && editors);
        }
        if (this.showCountersAction != null) {
            this.showCountersAction.setEnabled(!dasboards && editors);
        }
    }

    protected void fillStatusLine(IStatusLineManager statusBar) {
        try {
            statusBar.removeAll();
            if (this.alertContribution != null) {
                statusBar.add((IContributionItem)this.alertContribution);
            }
            statusBar.add((IContributionItem)this.statusContribution);
            if (this.dbContribution != null) {
                statusBar.add((IContributionItem)this.dbContribution);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.CONNECTED)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ApplicationActionBarAdvisor.this.updateStatusContribution();
                    ApplicationActionBarAdvisor.this.updateAlertsContribution();
                }
            });
            return;
        }
        if (event.is(LfcEvent.TYPE.DISCONNECTED)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ApplicationActionBarAdvisor.this.updateStatusContribution();
                    ApplicationActionBarAdvisor.this.updateAlertsContribution();
                    ApplicationActionBarAdvisor.this.updateDbContribution();
                }
            });
            return;
        }
        if (event.is(LfcEvent.TYPE.ALERTS)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ApplicationActionBarAdvisor.this.updateAlertsContribution();
                }
            });
            return;
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("show_alerts".equals(key)) {
            this.updateAlertsContribution();
            return;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.enableDashboardSensitiveActions();
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.enableDashboardSensitiveActions();
    }

    public void partActivated(IWorkbenchPart part) {
        this.enableDashboardSensitiveActions();
    }

    public void partClosed(IWorkbenchPart part) {
        this.enableDashboardSensitiveActions();
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

