/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.ApplicationWorkbenchAdvisor;
import com.moonlit.logfaces.client.net.LfsConnector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public class Application
implements IApplication {
    public static final String PLUGIN_ID = "com.moonlit.logfaces.client.plugin";
    private static Logger log;
    private static boolean exiting;
    private static IEclipsePreferences prefs;
    private static IDialogSettings dialogs;
    private static IApplicationContext context;

    public Object start(IApplicationContext ctx) throws Exception {
        context = ctx;
        this.initializeLogger();
        log.info("application is starting at {}, user dir: {}", (Object)FileUtils.toFile((URL)Platform.getInstallLocation().getURL()), (Object)System.getProperty("user.dir"));
        new InstallationTidy().run();
        Display display = PlatformUI.createDisplay();
        prefs = ConfigurationScope.INSTANCE.getNode(PLUGIN_ID);
        this.processCommandLine();
        this.loadDialogSettings();
        this.handleDeprecations();
        try {
            prefs.flush();
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Throwable ex) {
            log.fatal(ex.getMessage(), ex);
            Integer n = IApplication.EXIT_RELAUNCH;
            return n;
        }
        finally {
            log.info("application is closing...");
            exiting = true;
            LfsConnector.getInstance().terminate();
            display.dispose();
            prefs.flush();
            Application.saveDialogSettings();
            log.info("application is down");
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    public static boolean isServerMode() {
        return prefs.getBoolean("server_mode", false);
    }

    public static IEclipsePreferences getPrefs() {
        return prefs;
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static FontRegistry getFontRegistry() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        return currentTheme.getFontRegistry();
    }

    public static IDialogSettings getDialogSettings() {
        return dialogs;
    }

    public static IDialogSettings getDialogSettings(String subsecion, boolean create) {
        IDialogSettings settings = dialogs.getSection(subsecion);
        if (settings == null && create) {
            settings = dialogs.addNewSection(subsecion);
        }
        return settings;
    }

    public static void saveDialogSettings() {
        try {
            dialogs.save(String.format("%s%sdialogs.xml", Platform.getConfigurationLocation().getURL().getPath(), File.separator));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadDialogSettings() {
        try {
            dialogs = new DialogSettings("dialogs");
            File file = new File(String.format("%s%sdialogs.xml", Platform.getConfigurationLocation().getURL().getPath(), File.separator));
            if (!file.exists()) {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("dialogs.xml"), (File)file);
            }
            dialogs.load(file.getPath());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isExiting() {
        return exiting;
    }

    private void processCommandLine() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            i += 2;
        }
    }

    private void handleDeprecations() {
        String supportUrl = prefs.get("lfs_support_url", "https://moonlits.atlassian.net/servicedesk/customer/portals");
        if (supportUrl.contains("/www.moonlit-software.com/logfaces/helpdesk")) {
            prefs.put("lfs_support_url", "https://moonlits.atlassian.net/servicedesk/customer/portals");
        }
    }

    private void initializeLogger() throws Exception {
        ClassLoader cl = Application.class.getClassLoader();
        File file = new File(String.format("%s%slog4j2.xml", Platform.getConfigurationLocation().getURL().getPath(), File.separator));
        if (!file.exists()) {
            FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("log4j2.xml"), (File)file);
        }
        LoggerContext context = Configurator.initialize((String)"application", (ClassLoader)cl, (URI)file.toURI());
        Appender appender = context.getConfiguration().getAppender("LOG_FILE");
        ((RollingFileAppender)appender).getManager();
        log = LogManager.getLogger(this.getClass());
        BundleContext btx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceTracker logReaderTracker = new ServiceTracker(btx, LogReaderService.class.getName(), null);
        logReaderTracker.open();
        LogReaderService service = (LogReaderService)logReaderTracker.getService();
        service.addLogListener(new LogListener(){

            public void logged(LogEntry entry) {
                if (entry.getException() != null) {
                    log.log(this.toLevel(entry), entry.getMessage());
                } else {
                    log.log(this.toLevel(entry), entry.getMessage(), entry.getException());
                }
            }

            Level toLevel(LogEntry entry) {
                switch (entry.getLogLevel()) {
                    case INFO: {
                        return Level.INFO;
                    }
                    case WARN: {
                        return Level.WARN;
                    }
                    case ERROR: {
                        return Level.ERROR;
                    }
                }
                return Level.TRACE;
            }
        });
    }

    public static IApplicationContext getContext() {
        return context;
    }

    class InstallationTidy
    extends DirectoryWalker<File> {
        private String version = "";

        InstallationTidy() {
        }

        public void run() {
            try {
                Bundle plugin = Platform.getBundle((String)Application.PLUGIN_ID);
                this.version = plugin.getVersion().toString();
                URLConnection connection = FileLocator.resolve((URL)plugin.getEntry("/")).openConnection();
                if (!(connection instanceof JarURLConnection)) {
                    return;
                }
                URL url = ((JarURLConnection)connection).getJarFileURL();
                File dir = FileUtils.toFile((URL)url).getParentFile();
                log.info("{} version {} at {}", (Object)Application.PLUGIN_ID, (Object)this.version, (Object)dir.getCanonicalPath());
                this.walk(dir, Lists.newArrayList());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) {
            if (!file.getName().contains("com.moonlit.logfaces")) {
                return;
            }
            if (!file.getName().contains(this.version)) {
                log.info("tidying {}", (Object)file);
                FileUtils.deleteQuietly((File)file);
            }
        }

        protected boolean handleDirectory(File directory, int depth, Collection<File> results) {
            if (!directory.getName().contains("com.moonlit.logfaces")) {
                return depth == 0;
            }
            if (!directory.getName().contains(this.version)) {
                log.info("tidying {}", (Object)directory);
                FileUtils.deleteQuietly((File)directory);
            }
            return depth == 0;
        }
    }
}

