<?php
/**
 * Action form view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$st = $this->setting;

$classid = '.ipjck-widget-' . $this->widget->ID;
$label   = $st->getSetting( 'autoresponder_form_label', 'false' );
$action  = $st->getSetting( 'autoresponder_action' );
$nameon  = $st->getSetting( 'autoresponder_name_activate', 'true' );
$fname   = $st->getSetting( 'autoresponder_name' );
$femail  = $st->getSetting( 'autoresponder_email' );
$lname   = stripslashes(
  $st->getSetting( 'autoresponder_name_label', __( 'Your Name', IPJCK_SLUG  ) )
);
$lemail  = stripslashes(
  $st->getSetting( 'autoresponder_email_label', __( 'Your Email', IPJCK_SLUG  ) )
);

//Style
//
$template = $st->getSetting( 'template', 1 );
$layout   = $st->getSetting( 'form_layout', 'horizontal' );
if ( $this->widgetType == 'modal' && $template == 6 ||
		 $this->widgetType == 'bar' && ( $template == 5 || $template == 6 )
) {
	$layout = 'vertical';
}

$bgcolor = $st->getSetting( 'form_background_color', '#ffffff' );
$color   = $st->getSetting( 'form_text_color', '#666666' );
$bocolor = $st->getSetting( 'form_border_color', '#bbbbbb' );
$bowidth = $st->getSetting( 'form_border_width', 0 );
$radius  = $st->getSetting( 'form_border_radius', 'none' );
$size    = $st->getSetting( 'form_size', 'widthauto' );
$width   = $st->getSetting( 'form_width', 240 );

//Font
$fontsz   = $st->getSetting( 'form_font_size', 14 );
$font_opt = $st->getSetting( 'form_font_family', 'roboto' );
$family   = IPJck_Font::getFamily( $font_opt );
?>

<style>
<?php echo $classid; ?> .ipjck-form .ipjck-form-input {
	background-color: <?php echo $bgcolor; ?>!important;
	color: <?php echo $color; ?>;
	font-family: <?php echo $family; ?>;
	font-size: <?php echo $fontsz; ?>px;
	height: <?php echo $fontsz+24; ?>px;
	line-height: <?php echo $fontsz+24; ?>px;
	<?php
	if ( ! empty( $bowidth )) {
		echo 'border:' . $bowidth . 'px solid ' . $bocolor . '!important;';
	}

	if ( $this->widgetType == 'modal' && $template == 6 ||
		 $this->widgetType == 'bar' && ( $template == 5 || $template == 6 )
	) {
		echo 'width: 100%;';
	}
	elseif ( $size == 'widthcustom' ) {
		echo 'width:' . $width . 'px;';
	}
	?>
}
</style>

<!-- start: .ipjck-action-form -->
<div class="ipjck-action-form">
	<?php
	$formClass  = 'ipjck-form';
	$formClass .= ' ipjck-form-' . $layout;
	if ( $this->widgetType == 'modal' && $template == 6 ||
		 $this->widgetType == 'bar' && ( $template == 5 || $template == 6 ) ||
		 $size == 'widthauto'
	) {
		$formClass .= ' ipjck-width-auto';
	}

	$inputClass  = 'ipjck-form-input';
	$inputClass .= ' ipjck-radius-' . $radius;
	if ( $st->getSetting( 'form_inner_shadow', 'false' ) == 'true' ) {
		$inputClass .= ' ipjck-inner-shadow';
	}
	if ( $st->getSetting( 'form_outer_shadow', 'false' ) == 'true' ) {
		$inputClass .= ' ipjck-outer-shadow';
	}
	?>
	<!-- start: .ipjck-form -->
  <div class="<?php echo $formClass; ?>">
    <!-- start: .ipjck-form-main -->
    <form class="ipjck-form-main ipjck-clear" method="post" action="<?php echo $action; ?>">
      <!-- start: .ipjck-fields -->
      <div class="ipjck-fields ipjck-clear">

        <?php
        if ( $code = $st->getSetting( 'autoresponder_code' ) )
        {
          $data = IPJck_Form::parse( $code );
          if ( ! empty( $data['hiddens'] ))
          {
            foreach( $data['hiddens'] as $key => $value ) {
              $value    = str_replace( '"', '', $value );
              echo '<input type="hidden" name="' . $key . '" value="' . $value . '" />';
            }
          }
        }
        if ( $nameon == 'true' ) :
          $placeholder = ' placeholder="' . $lname . '"';
        ?>
        <div class="ipjck-field">
          <?php
          if ( $label == 'true' ):
            $placeholder = '';
          ?>
          <div class="ipjck-form-label">
            <label for="ipjck-input-name"><?php echo $lname; ?> (*)</label>
          </div>
          <?php
          endif;
          ?>
          <div class="ipjck-form-control">
            <input type="text" class="<?php echo $inputClass; ?>" id="ipjck-input-name" name="<?php echo $fname; ?>" value=""<?php echo $placeholder; ?>>
          </div>
        </div>
        <?php
        endif;
        ?>
        <div class="ipjck-field">
          <?php
          $placeholder = ' placeholder="' . $lemail . '"';
          if ( $label == 'true' ):
            $placeholder = '';
          ?>
          <div class="ipjck-form-label">
            <label for="ipjck-input-email"><?php echo $lemail; ?> (*)</label>
          </div>
          <?php
          endif;
          ?>
          <div class="ipjck-form-control">
            <input type="text" class="<?php echo $inputClass; ?>" id="ipjck-input-email" name="<?php echo $femail; ?>" value=""<?php echo $placeholder; ?>>
          </div>
        </div>

      </div>
      <!-- end: .ipjck-fields -->

      <!-- start: .ipjck-form-submit -->
      <div class="ipjck-form-submit">

      	<?php
				$label    = stripslashes( $st->getSetting( 'form_button_label' ) );
				$icon     = stripslashes( $st->getSetting( 'form_button_icon' ) );
				$template = $st->getSetting( 'form_button_template', 1 );
				$color    = $st->getSetting( 'form_button_style_color', 'clean' );
				$size     = $st->getSetting( 'form_button_size', 'lg' );
				$icpos    = $st->getSetting( 'form_button_icon_position', 'left' );
				$radius   = $st->getSetting( 'form_button_radius', 'none' );
				?>
				<div class="ipjck-button-wrapper">
				  <?php
				  $class  = 'ipjck-button';
				  $class .= ' ipjck-template-' . $template;
				  $class .= ' ipjck-' . $color;
				  $class .= ' ipjck-' . $size;
				  $class .= ' ipjck-icon-' . $icpos;
				  $class .= ' ipjck-radius-' . $radius;

				  if ( $st->getSetting( 'form_button_full_width', 'false' ) == 'true' ) {
				  	$class .= ' ipjck-full-width';
				  }

				  $adata  = '';
				  if ( isset( $this->widget )) {
				    $adata = ' data-widget-id="' . $this->widget->ID . '"';
				  }
				  ?>
				  <button type="submit" class="<?php echo $class; ?>" <?php echo $adata; ?>>
				    <span class="ipjck-button-inner">
				      <?php
				      if ( ! empty( $icon ) && $icpos == 'left' ) :
				      ?>
				      <span class="ipjck-button-icon">
				        <i class="ipjck-fa ipjck-<?php echo $icon; ?>"></i>
				      </span>
				      <?php
				      endif;
				      ?>
				      <span class="ipjck-button-label">
				        <?php echo $label; ?>
				      </span>
				      <?php
				      if ( ! empty( $icon ) && $icpos == 'right' ) :
				      ?>
				      <span class="ipjck-button-icon">
				        <i class="ipjck-fa ipjck-<?php echo $icon; ?>"></i>
				      </span>
				      <?php
				      endif;
				      ?>
				    </span>
				  </button>
				</div>

      </div>
      <!-- end: .ipjck-submit -->
    </form>
    <!-- end: .ipjck-form-main -->
  </div>
  <!-- end: .ipjck-form -->

</div>
<!-- end: .ipjck-action-form -->