<?php
/**
 * Action button view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$st = $this->setting;
?>

<!-- start: .ipjck-action-button -->
<div class="ipjck-action-button">
	<?php
	$url      = $st->getSetting( 'button_url', '#' );
	$label    = stripslashes( $st->getSetting( 'button_label' ) );
	$icon     = stripslashes( $st->getSetting( 'button_icon' ) );
	$template = $st->getSetting( 'button_template', 1 );
	$color    = $st->getSetting( 'button_style_color', 'clean' );
	$size     = $st->getSetting( 'button_size', 'lg' );
	$icpos    = $st->getSetting( 'button_icon_position', 'left' );
	$radius   = $st->getSetting( 'button_radius', 'none' );
	?>
	<div class="ipjck-button-wrapper">
	  <?php
	  $class  = 'ipjck-button';
	  $class .= ' ipjck-template-' . $template;
	  $class .= ' ipjck-' . $color;
	  $class .= ' ipjck-' . $size;
	  $class .= ' ipjck-icon-' . $icpos;
	  $class .= ' ipjck-radius-' . $radius;

	  if ( $st->getSetting( 'button_full_width', 'false' ) == 'true' ) {
	  	$class .= ' ipjck-full-width';
	  }

	  $adata  = '';
	  if ( isset( $this->widget )) {
	    $adata = ' data-widget-id="' . $this->widget->ID . '"';
	  }
	  ?>
	  <a href="<?php echo $url; ?>" class="<?php echo $class; ?>" <?php echo $adata; ?>>
	    <span class="ipjck-button-inner">
	      <?php
	      if ( ! empty( $icon ) && $icpos == 'left' ) :
	      ?>
	      <span class="ipjck-button-icon">
	        <i class="ipjck-fa ipjck-<?php echo $icon; ?>"></i>
	      </span>
	      <?php
	      endif;
	      ?>
	      <span class="ipjck-button-label">
	        <?php echo $label; ?>
	      </span>
	      <?php
	      if ( ! empty( $icon ) && $icpos == 'right' ) :
	      ?>
	      <span class="ipjck-button-icon">
	        <i class="ipjck-fa ipjck-<?php echo $icon; ?>"></i>
	      </span>
	      <?php
	      endif;
	      ?>
	    </span>
	  </a>
	</div>

</div>
<!-- end: .ipjck-action-button -->