<?php
/**
 * Widget view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! isset( $this->widget ) || ! $this->widget ) {
  return;
}
//
//Get view based widget type and template
$template   = $this->setting->getSetting( 'template', '1' );
$widgetType = $this->widgetType;
$viewPath   = 'front/' . $widgetType . '/template' . $template;
$rootClass  = 'ipjck-widget';
$rootClass .= ' ipjck-widget-' . $this->widget->ID;
$rootClass .= ' ipjck-' . $widgetType;
$rootClass .= ' ipjck-template-' . $template;

if ( $widgetType == 'bar' ) {
	$rootClass .= ' ipjck-bar-' . $this->setting->getSetting( 'bar_position', 'top' );
}
elseif ( $widgetType == 'slide' ) {
	$rootClass .= ' ipjck-slide-' . $this->setting->getSetting( 'slide_position', 'top' );
}

if ( $widgetType == 'modal' ) 
{
	$modalSize  = $this->setting->getSetting( 'modal_size', 'custom' );
	if ( $modalSize == 'full' ) {
		$rootClass .= ' ipjck-modal-full';
	}
}

$this->view( 'front/' . $widgetType . '/style' );

//
//Display control
$hidden = '';
if ( isset( $this->isPreview )) {
  $rootClass .= ' ipjck-widget-preview ipjck-widget-hide';
  $hidden     = ' style="display:none;"';
}
else 
{
	$firstShow  = $this->setting->getSetting( 'first_show_type', 'visible' );
	$rootClass .= ' ipjck-widget-first-' . $firstShow;
}
?>

<div class="<?php echo $rootClass; ?>"<?php echo $hidden; ?>>
	<div class="ipjck-widget-inner">

		<div class="ipjck-widget-content">
			<?php
			$this->view( $viewPath );

			//Minimize & close link
			if ( $widgetType != 'slide' ) {
				$this->view( 'front/widget/close' );
			}
			?>
		</div>

	</div>

	<?php
	if ( $widgetType == 'modal' ) {
		$this->view( 'front/modal/bgoverlay' );
	}
	?>

	<?php
	//Submission
	$this->view( 'front/widget/submission' );
	//Behaviour
	$this->view( 'front/widget/behaviour' );
	//Effect
	$this->view( 'front/widget/effect' );
	?>
</div>

<?php
if ( ! isset( $this->isPreview )) :
?>
<div id="ipjck-message-email-empty" class="ipjck-form-message">
	<div class="ipjck-alert ipjck-alert-danger">
		<span><?php _e( 'Email cannot be empty', IPJCK_SLUG ); ?></span>
		<a href=""><i class="ipjck-fa ipjck-fa-times"></i></a>
	</div>
</div>
<div id="ipjck-message-name-empty" class="ipjck-form-message">
	<div class="ipjck-alert ipjck-alert-danger">
		<span><?php _e( 'Name cannot be empty', IPJCK_SLUG ); ?></span>
		<a href=""><i class="ipjck-fa ipjck-fa-times"></i></a>
	</div>
</div>
<div id="ipjck-message-email-wrong" class="ipjck-form-message">
	<div class="ipjck-alert ipjck-alert-danger">
		<span><?php _e( 'The email is not a valid email address.', IPJCK_SLUG ); ?></span>
		<a href=""><i class="ipjck-fa ipjck-fa-times"></i></a>
	</div>
</div>
<div id="ipjck-message-error" class="ipjck-form-message">
	<div class="ipjck-alert ipjck-alert-danger">
		<span></span>
		<a href=""><i class="ipjck-fa ipjck-fa-times"></i></a>
	</div>
</div>
<div id="ipjck-message-success" class="ipjck-form-message">
	<div class="ipjck-alert ipjck-alert-success">
		<span></span>
		<a href=""><i class="ipjck-fa ipjck-fa-times"></i></a>
	</div>
</div>
<?php
endif;
?>