<?php
/**
 * Modal template 2 content view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$st = $this->setting;

//Include style border
$this->borderPosition = 'all';
$this->view( 'front/widget/style_border' );

//Include style bg main
$this->view( 'front/slide/style_bgmain' );

//
//Header style
$classid = '.ipjck-widget-' . $this->widget->ID;
$bgcolor = $st->getSetting( 'box_secondary_background_color', '#f9f9f9' );
$padding = $st->getSetting( 'box_secondary_padding', '15' );

//Get general text color
$phpcolor = new phpColor( $bgcolor );
if ( $phpcolor->isDark() ) {
	$color = $phpcolor->lighten( 60 );
} else {
	$color = $phpcolor->darken( 60 );
}

//Background Image
$imgurl = false;
if ( $bgimg = $st->getSetting( 'box_secondary_background_image' ))
{
  $data = wp_get_attachment_image_src( $bgimg, 'full' );
  if ( ! empty( $data[0] )) {
    $imgurl = $data[0];
  }
}
$repeat  = $st->getSetting( 'box_secondary_background_repeat', 'repeat' );
$opvalue = $st->getSetting( 'box_secondary_background_opacity', 0 );
?>

<style>
	<?php echo $classid; ?> .ipjck-header {
		color: #<?php echo $color; ?>;
		background-color: <?php echo $bgcolor; ?>;
	}
	<?php
	if ( $imgurl ) :
	?>
	<?php echo $classid; ?> .ipjck-header-bg {
		background-image: url('<?php echo $imgurl; ?>');
		background-repeat: <?php echo $repeat; ?>;
		<?php
		if ( ! empty( $opvalue )) 
		{
			$opacity = 1 - ($opvalue/100);
			echo 'opacity:' . $opacity . ';';
		}
		?>
	}
	<?php
	else:
	?>
	<?php echo $classid; ?> .ipjck-header-bg {
		display: none;
	}
	<?php
	endif;
	?>
</style>

<!-- start: .ipjck-widget-main -->
<div class="ipjck-widget-main">
	<!-- start: .ipjck-widget-main-inner -->
	<div class="ipjck-widget-main-inner">

		<!-- start: .ipjck-content -->
		<div class="ipjck-content">

			<div class="ipjck-header">
				<div class="ipjck-header-inner">
					<?php
					$this->view( 'front/widget/title' );
					?>
					<div class="ipjck-widget-links">
						<?php 
						$this->view( 'front/widget/minimize' );
						$this->view( 'front/widget/close' );
						?>
					</div>
				</div>
				<div class="ipjck-header-bg"></div>
			</div>

			<div class="ipjck-content-primary">

				<?php
				$this->view( 'front/widget/info' );

				$type = $st->getSetting( 'media_type', 'none' );
				if ( $type != 'none' ) {
					$this->view( 'front/widget/media' );
				}

				$this->view( 'front/widget/action' );
				$this->view( 'front/widget/footer' );
				?>

			</div>
			
		</div>
		<!-- end: .ipjck-content -->

	</div>
	<!-- end: .ipjck-widget-main-inner -->

	<div class="ipjck-widget-main-bg"></div>
</div>
<!-- end: .ipjck-widget-main -->