<?php
/**
 * Text options view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>

<h4 class="ipjck-field-title mb0 py10">
	<?php _e( 'Text', IPJCK_SLUG ); ?>
</h4>


<?php
/*
 * Title Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-title-color"><?php _e( 'Title Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'box_title_color', '#333333' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-box-title-color" name="box_title_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Set the color for the title content.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Font Size
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-box-title-size"><?php _e( 'Title Font Size', IPJCK_SLUG ); ?></label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <?php
    $size = absint( $setting->getSetting( 'box_title_size', '18' ) );
    ?>
    <div class="ipjck-input-group mr5">
      <input type="text" id="input-box-title-size" class="ipjck-input ipjck-input-xxs" name="box_title_size" value="<?php echo $size; ?>">
      <div class="ipjck-input-addon">px</div>
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set the font size of the title.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
//Font Family
?>
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-title-font"><?php _e( 'Title Font Family', IPJCK_SLUG ); ?></label>
	</div>
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$current = $setting->getSetting( 'box_title_font', 'roboto' );
		$fonts   = IPJck_Font::getOptions();
		$fname   = IPJck_Font::getFontName( $current );
		?>
		<span class="ipjck-font-family">
			<div class="ipjck-menu ipjck-fancy-option">
				<div class="ipjck-selected">
					<div class="ipjck-selected-box">
						<span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
					</div>
					<span class="toggle"></span>
				</div>
				<div class="ipjck-select" style="display: none;">
					<div class="ipjck-select-content">
						<ul class="clearfix">
							<?php
							foreach( $fonts as $fkey => $label ) :
							?>
							<li data-select="<?php echo $fkey; ?>">
								<strong class="ipjck-select-label">
									<?php echo $label; ?>
								</strong>
							</li>
							<?php
							endforeach;
							?>
						</ul>
					</div>
				</div>
				<input type="hidden" name="box_title_font" class="ipjck-input-select" value="<?php echo $current; ?>" />
			</div>
		</span>

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'The font family of the title in your box widget.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
</div>


<?php
//
//Title text shadow
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-md-3 col-sm-12">
    <label for="input-box-title-shadow">
      <?php _e( 'Title Text Shadow', IPJCK_SLUG ); ?>
    </label>
  </div>
  <div class="ipjck-field col-md-9 col-sm-12">

    <div class="ipjck-onoff">
      <?php
      $val = $setting->getSetting( 'box_title_shadow', 'false' );
      if ( $val == 'false' ) {
          $clon  = '';
          $cloff = ' active';
      } else {
          $clon  = ' active';
          $cloff = '';
      }
      ?>
      <div class="ipjck-btn-group">
        <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
        <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
      </div>
      <input type="hidden" class="ipjck-onoff-value" name="box_title_shadow" value="<?php echo $val; ?>" />
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set to true if you want to show the text shadow in title.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->


<?php
/*
 * Info Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-info-color"><?php _e( 'Info Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'box_info_color', '#555555' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-box-info-color" name="box_info_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Set the color for the info content.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Info Font Size
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-box-info-size"><?php _e( 'Info Font Size', IPJCK_SLUG ); ?></label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <?php
    $size = absint( $setting->getSetting( 'box_info_size', '14' ) );
    ?>
    <div class="ipjck-input-group mr5">
      <input type="text" id="input-box-info-size" class="ipjck-input ipjck-input-xxs" name="box_info_size" value="<?php echo $size; ?>">
      <div class="ipjck-input-addon">px</div>
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set the font size of the info.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
//Info Font Family
?>
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-info-font"><?php _e( 'Info Font Family', IPJCK_SLUG ); ?></label>
	</div>
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$current = $setting->getSetting( 'box_info_font', 'roboto' );
		$fonts   = IPJck_Font::getOptions();
		$fname   = IPJck_Font::getFontName( $current );
		?>
		<span class="ipjck-font-family">
			<div class="ipjck-menu ipjck-fancy-option">
				<div class="ipjck-selected">
					<div class="ipjck-selected-box">
						<span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
					</div>
					<span class="toggle"></span>
				</div>
				<div class="ipjck-select" style="display: none;">
					<div class="ipjck-select-content">
						<ul class="clearfix">
							<?php
							foreach( $fonts as $fkey => $label ) :
							?>
							<li data-select="<?php echo $fkey; ?>">
								<strong class="ipjck-select-label">
									<?php echo $label; ?>
								</strong>
							</li>
							<?php
							endforeach;
							?>
						</ul>
					</div>
				</div>
				<input type="hidden" name="box_info_font" class="ipjck-input-select" value="<?php echo $current; ?>" />
			</div>
		</span>

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'The font family of the title in your box widget.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
</div>

<?php
//Info text shadow
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-md-3 col-sm-12">
    <label for="input-box-info-shadow">
      <?php _e( 'Info Text Shadow', IPJCK_SLUG ); ?>
    </label>
  </div>
  <div class="ipjck-field col-md-9 col-sm-12">

    <div class="ipjck-onoff">
      <?php
      $val = $setting->getSetting( 'box_info_shadow', 'false' );
      if ( $val == 'false' ) {
          $clon  = '';
          $cloff = ' active';
      } else {
          $clon  = ' active';
          $cloff = '';
      }
      ?>
      <div class="ipjck-btn-group">
        <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
        <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
      </div>
      <input type="hidden" class="ipjck-onoff-value" name="box_info_shadow" value="<?php echo $val; ?>" />
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set to true if you want to show the text shadow in info.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->