<?php
/**
 * Border options
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>

<h4 class="ipjck-field-title mb0 py10">
	<?php _e( 'Border', IPJCK_SLUG ); ?>
</h4>


<?php
/*
 * Border Size
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-border-size"><?php _e( 'Border Size', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$size = absint( $setting->getSetting( 'box_border_size', 4 ) );
		?>
		<div class="ipjck-input-group mr5">
			<input type="text" id="input-box-border-size" class="ipjck-input ipjck-input-xxs" name="box_border_size" value="<?php echo $size; ?>">
			<div class="ipjck-input-addon">px</div>
		</div>

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Set border size for the box widget.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->


<?php
/*
 * Border Style
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-box-border-style">
      <?php _e( 'Border Style', IPJCK_SLUG ); ?>
    </label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <select name="box_border_style" id="input-box-border-style" class="ipjck-input">
      <?php
      $current = $setting->getSetting( 'box_border_style', 'solid' );
      $types   = array(
        'solid'   => __( 'Solid', IPJCK_SLUG ),
        'dashed'  => __( 'Dashed', IPJCK_SLUG ),
        'dotted'  => __( 'Dotted', IPJCK_SLUG ),
        'double'  => __( 'Double', IPJCK_SLUG ),
        'groove'  => __( 'Groove', IPJCK_SLUG )
      );
      foreach( $types as $key => $label )
      {
        $sltd = '';
        if ( $current == $key ) {
          $sltd = ' selected="selected"';
        }
        echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
      }
      ?>
    </select>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set border style for the box widget.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->


<?php
/*
 * Border Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-border-color"><?php _e( 'Border Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'box_border_color', '#666666' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-box-border-color" name="box_border_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Set border color for the box widget.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->


<?php
//Border radius
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-box-border-radius"><?php _e( 'Border Radius', IPJCK_SLUG ); ?></label>
	</div>
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<select name="box_border_radius" id="input-box-border-radius">
		<?php
		$current = stripslashes( $setting->getSetting( 'box_border_radius', 'none' ));
		$styles  = array(
			'none' => __( 'None', IPJCK_SLUG ),
			'xs'   => __( 'Extra Small', IPJCK_SLUG ),
			'sm'   => __( 'Small', IPJCK_SLUG ),
			'md'   => __( 'Medium', IPJCK_SLUG ),
			'lg'   => __( 'Large', IPJCK_SLUG )
		);
		foreach( $styles as $key => $label ) {
			$sltd = '';
			if ( $key == $current ) {
				$sltd = ' selected="selected"';
			}
			echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
		}
		?>
		</select>

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Add radius in the box widget.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
</div>
<!-- end: .ipjck-field-row -->