<?php
/**
 * Background options
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
$dspBg = '';
if ( isset( $this->hideBackground )) {
	$dspBg = ' style="display:none"';
}
?>

<div id="ipjck-field-background"<?php echo $dspBg; ?>>

	<h4 class="ipjck-field-title mb0 py10">
		<?php _e( 'Background', IPJCK_SLUG ); ?>
	</h4>

	<?php
	/*
	 * Background Color
	 */
	?>
	<!-- start: .ipjck-field-row -->
	<div class="ipjck-field-row ipjck-field-x">
		<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
			<label for="input-box-background-color"><?php _e( 'Background Color', IPJCK_SLUG ); ?></label>
		</div>

		<!-- start: .ipjck-field -->
		<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

			<?php
			$color = stripslashes( $setting->getSetting( 'box_background_color', '#666666' ) );
			?>
			<input type="text" class="ipjck-color-picker" id="input-box-background-color" name="box_background_color" value="<?php echo $color; ?>" />

			<div class="ipjck-help">
				<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
				<div class="ipjck-help-content ipjck-hide">
					<?php _e( 'Set background color for the box widget.', IPJCK_SLUG ); ?>
				</div>
			</div>
		</div>
		<!-- end: .ipjck-field -->
	</div>
	<!-- end: .ipjck-field-row -->

	<?php
	/*
	 * Background Image
	 */
	?>
	<!-- start: .ipjck-field-row -->
	<div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
		<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
			<label for="input-box-background-image"><?php _e( 'Background Image', IPJCK_SLUG ); ?></label>
		</div>

		<!-- start: .ipjck-field -->
		<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

			<div class="ipjck-upload-image ipjck-clear">
				<div class="ipjck-upload-preview">
					<?php
						$setimg = false;
						if ( $attach_id = $setting->getSetting( 'box_background_image' ) ) {
							$setimg = true;
							$data   = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
						}
						if ( $setimg ) {
							echo '<div class="image"><img src="' . $data[0] . '" /></div>';
							echo '<div class="none ipjck-hide">' . __( 'No image', IPJCK_SLUG ) . '</div>';
							$reset_dsp = '';
						} else {
							echo '<div class="image"></div>';
							echo '<div class="none">' . __( 'No image', IPJCK_SLUG ) . '</div>';
							$reset_dsp = ' style="display:none;"';
						}
					?>
				</div>

				<div class="ipjck-image-field">
					<div class="ipjck-select-image">
						<p class="mt0"><?php _e( 'Select an image or upload new image using the button below.', IPJCK_SLUG ); ?></p>
						<a class="ipjck-btn ipjck-btn-secondary ipjck-btn-media ipjck-btn-sm" data-choose="<?php esc_attr_e( 'Choose Image', IPJCK_SLUG ); ?>"
							data-update="<?php esc_attr_e( 'Choose image', IPJCK_SLUG ); ?>">
							<i class="ipjck-fa ipjck-fa-image"></i>
							<?php _e( 'Select Image', IPJCK_SLUG ); ?>
						</a>
						<a class="ipjck-btn ipjck-btn-reset ipjck-btn-sm" href="#"<?php echo $reset_dsp; ?>>
							<i class="ipjck-fa ipjck-fa-ban"></i>
							<?php _e( 'Clear Image', IPJCK_SLUG ); ?>
						</a>
					</div>
					<input type="hidden" name="upload_type" class="ipjck-upload-type" value="box_background_image" />
					<input type="hidden" name="box_background_image" class="ipjck-image-id" value="<?php echo $attach_id; ?>" />
				</div>
			</div>

			<div class="ipjck-help">
				<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
				<div class="ipjck-help-content ipjck-hide">
					<?php _e( 'The background image in the box widget.', IPJCK_SLUG ); ?>
				</div>
			</div>
		</div>
		<!-- end: .ipjck-field -->
	</div>
	<!-- end: .ipjck-field-row -->

	<?php
	/*
	 * Background repeat
	 */
	?>
	<!-- start: .ipjck-field-row -->
	<div class="ipjck-field-row ipjck-field-x">
		<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
			<label for="input-box-background-repeat"><?php _e( 'Background Repeat', IPJCK_SLUG ); ?></label>
		</div>

		<!-- start: .ipjck-field -->
		<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
			<?php
			$repeat  = $setting->getSetting( 'box_background_repeat' );
			$options = array(
				'no-repeat'   => __( 'No Repeat', IPJCK_SLUG ),
				'repeat-x'    => __( 'Repeat Horizontally', IPJCK_SLUG ),
				'repeat-y'    => __( 'Repeat Vertically', IPJCK_SLUG ),
				'repeat'      => __( 'Repeat All', IPJCK_SLUG ),
			);
			?>
			<select name="box_background_repeat" id="input-box-background-repeat">
				<?php
				foreach( $options as $key => $label )
				{
					$sltd = '';
					if ( $key == $repeat ) {
						$sltd = ' selected="selected"';
					}
					echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
				}
				?>
			</select>

			<div class="ipjck-help">
				<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
				<div class="ipjck-help-content ipjck-hide">
					<?php _e( 'The alignment background in box widget.', IPJCK_SLUG ); ?>
				</div>
			</div>
		</div>
		<!-- end: .ipjck-field -->
	</div>
	<!-- end: .ipjck-field-row -->

	<?php
	/*
	 * Background opacity
	 */
	?>
	<!-- start: .ipjck-field-row -->
	<div class="ipjck-field-row ipjck-field-x">
		<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
			<label for="input-box-background-opacity">
				<?php _e( 'Background Opacity', IPJCK_SLUG ); ?>
			</label>
		</div>

		<!-- start: .ipjck-field -->
		<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
			<?php
			$opacity = $setting->getSetting( 'box_background_opacity' );
			$options = array(
					0    => __( 'None', IPJCK_SLUG ),
					10   => __( '10%', IPJCK_SLUG ),
					20   => __( '20%', IPJCK_SLUG ),
					30   => __( '30%', IPJCK_SLUG ),
					40   => __( '40%', IPJCK_SLUG ),
					50   => __( '50%', IPJCK_SLUG ),
					60   => __( '60%', IPJCK_SLUG ),
					70   => __( '70%', IPJCK_SLUG ),
					80   => __( '80%', IPJCK_SLUG ),
					90   => __( '90%', IPJCK_SLUG ),
			);
			?>
			<select name="box_background_opacity" id="input-box-background-opacity">
				<?php
				foreach( $options as $key => $label )
				{
					$sltd = '';
					if ( $key == $opacity ) {
						$sltd = ' selected="selected"';
					}
					echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
				}
				?>
			</select>

			<div class="ipjck-help">
				<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
				<div class="ipjck-help-content ipjck-hide">
					<?php _e( 'Make transparency for the background image.', IPJCK_SLUG ); ?>
				</div>
			</div>
		</div>
		<!-- end: .ipjck-field -->
	</div>
	<!-- end: .ipjck-field-row -->

</div>