<?php
/**
 * Admin submission content view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>
<div id="ipjck-section-submission" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-send"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Submission', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Regulate how the plugin handles submission.', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields ipjck-section-select">

      <?php
      //List
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-list"><?php _e( 'List', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select id="input-list" class="ipjck-input" name="list">
            <option value="0">
              <?php _e( '-- Select List --', IPJCK_SLUG );  ?>
            </option>

            <?php
            $model   = new IPJck_Model_List();
            $lists   = $model->getLists( array(
                'orderby'   => 'list_created',
                'order'     => 'DESC'
            ));
            $current = $setting->getSetting( 'list' );
            var_dump($current);
            foreach( $lists as $list ) {
              $sltd = '';
              if ( $list->list_id == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $list->list_id . '"' . $sltd . '>' . $list->list_name . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the campaign that will deal with this widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Successfull Submission

      /*
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-submission-success">
            <?php _e( 'Successfull Submission', IPJCK_SLUG ); ?>
          </label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select id="input-submission-success" class="ipjck-input ipjck-section-select-options" name="submission_success">
            <?php
            $options = array(
              'message'  => __( 'Display a message', IPJCK_SLUG ),
              'redirect' => __( 'Redirect User', IPJCK_SLUG ),
            );
            $current = $setting->getSetting( 'submission_success', 'message' );
            foreach( $options as $key => $label ) {
              $sltd = '';
              if ( $key == $current ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the campaign that will deal with this widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      */

      //Successfull Submission
      ?>
      
      <!-- start: .ipjck-section-select-content -->
      <div id="ipjck-section-message" class="ipjck-section-select-content" style="border-bottom:1px solid #ddd;">

        <!-- start: .ipjck-field-row -->
        <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
          <div class="ipjck-form-label col-md-3 col-sm-12">
            <label for="input-submission-success-message">
              <?php _e( 'Message After Success', IPJCK_SLUG ); ?>
            </label>
          </div>
          <div class="ipjck-field col-md-9 col-sm-12">

           <?php
            $message = stripslashes( $setting->getSetting( 'submission_success_message' ) );
            ?>
            <textarea id="input-submission-success-message" class="ipjck-input ipjck-input-full" name="submission_success_message" rows="6"><?php echo $message; ?></textarea>

            <div class="ipjck-help">
              <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
              <div class="ipjck-help-content ipjck-hide">
                <?php _e( 'Set the message that displaying after submission is success.', IPJCK_SLUG ); ?>
              </div>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field-row -->

        <?php
        //Close Widget

        /*
        ?>

        <!-- start: .ipjck-field-row -->
        <div class="ipjck-field-row ipjck-field-x">
          <div class="ipjck-form-label col-md-3 col-sm-12">
            <label for="input-submission-success-close">
              <?php _e( 'Close Widget', IPJCK_SLUG ); ?>
            </label>
          </div>
          <div class="ipjck-field col-md-9 col-sm-12">

            <div class="ipjck-onoff">
            <?php
            $val = $this->setting->getSetting( 'submission_success_close', 'true' );
            if ( $val == 'false' ) {
                $clon  = '';
                $cloff = ' active';
            } else {
                $clon  = ' active';
                $cloff = '';
            }
            ?>
            <div class="ipjck-btn-group">
              <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
              <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
            </div>
            <input type="hidden" class="ipjck-onoff-value" name="submission_success_close" value="<?php echo $val; ?>" />
          </div>

            <div class="ipjck-help">
              <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
              <div class="ipjck-help-content ipjck-hide">
                <?php _e( 'Determine whether to hide the widget after the submission process.', IPJCK_SLUG ); ?>
              </div>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field-row -->

        <?php
        */
        ?>

      </div>
      <!-- end: .ipjck-section-select-content -->

      <?php
      //Redirect
      ?>
      <!-- start: .ipjck-field-row -->
      <div id="ipjck-section-redirect" class="ipjck-field-row ipjck-field-x ipjck-section-select-content ipjck-help-abs" style="display:none;">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-submission-success-redirect">
            <?php _e( 'Redirect URL', IPJCK_SLUG ); ?>
          </label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <?php
          $redirect = $setting->getSetting( 'submission_success_redirect' );
          ?>

          <input type="text" id="input-submission-success-redirect" class="ipjck-input ipjck-input-full" name="submission_success_redirect" value="<?php echo $redirect; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the url of the redirect page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Failed Submission
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-submission-failed-message">
            <?php _e( 'Failed Submission Message', IPJCK_SLUG ); ?>
          </label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

         <?php
          $message = stripslashes( $setting->getSetting( 'submission_failed_message' ) );
          ?>
          <textarea id="input-submission-failed-message" class="ipjck-input ipjck-input-full" name="submission_failed_message" rows="6"><?php echo $message; ?></textarea>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the message that displaying after submission is failed.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>