<?php
/**
 * Admin content effect view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-section-effect" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-magic"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Effect', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the effect when the widget to appear/hide.', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <?php
      //Show Effect
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-show-effect"><?php _e( 'Show Animation', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select name="show_effect" id="input-show-effect">
            <?php
            $current = $this->setting->getSetting( 'show_effect', 'none' );
            $effects = IPJck_Effect::getInAnimations();
            foreach( $effects as $key )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $key . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The type of effect that is executed when the widget is displayed.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Show effect speed
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-show-effect-speed"><?php _e( 'Show Animation Speed', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $speed = $this->setting->getSetting( 'show_effect_speed', 500 );
          ?>
          <div class="ipjck-input-group mr5">
              <input type="text" id="input-show-effect-speed" class="ipjck-input ipjck-input-xs" name="show_effect_speed" value="<?php echo $speed; ?>">
              <div class="ipjck-input-addon">second</div>
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The speed (in second) of effect that is executed when the widget is displayed.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Hide Effect
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-hide-effect"><?php _e( 'Hide Animation', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select name="hide_effect" id="input-hide-effect">
            <?php
            $current = $this->setting->getSetting( 'hide_effect', 'none' );
            $effects = IPJck_Effect::getOutAnimations();
            foreach( $effects as $key )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $key . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The type of effect that is executed when the widget is hidden.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Hide effect speed
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-hide-effect-speed"><?php _e( 'Hide Animation Speed', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $speed = $this->setting->getSetting( 'hide_effect_speed', 500 );
          ?>
          <div class="ipjck-input-group mr5">
              <input type="text" id="input-hide-effect-speed" class="ipjck-input ipjck-input-xs" name="hide_effect_speed" value="<?php echo $speed; ?>">
              <div class="ipjck-input-addon">second</div>
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The speed (in second) of effect that is executed when the widget is hidden.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Show Audio
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-show-audio"><?php _e( 'Show Audio', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select id="input-show-audio" class="ipjck-input" name="show_audio">
            <option value="0"> <?php _e( 'No Audio', IPJCK_SLUG );  ?> </option>
            <?php
            $audio   = absint( $this->setting->getSetting( 'show_audio', 0 ) );
            $options = range(1,5);
            foreach( $options as $key ) {
              $sltd = '';
              if ( $key == $audio ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>Audio #' . $key . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The sound effect when the widget is displayed.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Hide Audio
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-hide-audio"><?php _e( 'Hide Audio', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select id="input-hide-audio" class="ipjck-input" name="hide_audio">
            <option value="0"> <?php _e( 'No Audio', IPJCK_SLUG );  ?> </option>
            <?php
            $audio   = absint( $this->setting->getSetting( 'hide_audio', 0 ) );
            $options = range(1,5);
            foreach( $options as $key ) {
              $sltd = '';
              if ( $key == $audio ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>Audio #' . $key . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The sound effect when the widget is hidden.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Disabled Animation
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-status"><?php _e( 'Disabled Animation on Mobile', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipjck-onoff">
            <?php
            $val = $this->setting->getSetting( 'disabled_animation_mobile', 'true' );
            if ( $val == 'false' ) {
                $clon  = '';
                $cloff = ' active';
            } else {
                $clon  = ' active';
                $cloff = '';
            }
            ?>
            <div class="ipjck-btn-group">
              <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
              <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
            </div>
            <input type="hidden" class="ipjck-onoff-value" name="disabled_animation_mobile" value="<?php echo $val; ?>" />
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Determine whether to turn off the animation when it is on the small size device.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>
