<?php
/**
 * Manage box style view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-section-design" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-paint-brush"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Design', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the style of the widget', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <?php
      /*
       * Widget Width
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-widget-width"><?php _e( 'Widget Width', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $width = $this->setting->getSetting( 'widget_width', 280 );
          ?>
          <div class="ipjck-input-group mr5">
              <input type="text" id="input-widget-width" class="ipjck-input ipjck-input-xs" name="widget_width" value="<?php echo $width; ?>">
              <div class="ipjck-input-addon">px</div>
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Width ( in pixel ) of the widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Style
			 */
			?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-box-style"><?php _e( 'Style', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $style   = $this->setting->getSetting( 'box_style' );
          $options = array(
              1 => __( 'Style #1', IPJCK_SLUG ),
              2 => __( 'Style #2', IPJCK_SLUG ),
              3 => __( 'Style #3', IPJCK_SLUG ),
              4 => __( 'Style #4', IPJCK_SLUG ),
              5 => __( 'Style #5', IPJCK_SLUG ),
              6 => __( 'Style #6', IPJCK_SLUG ),
              7 => __( 'Style #7', IPJCK_SLUG )
          );
          ?>
          <select name="box_style" id="input-box-style">
            <?php
            foreach( $options as $key => $label )
            {
                $sltd = '';
                if ( $key == $style ) {
                    $sltd = ' selected="selected"';
                }
                echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the style of the box.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->



      <?php
      /*
       * Shadow
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-box-shadow"><?php _e( 'Box Shadow', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipjck-onoff">
              <?php
              $val  = $this->setting->getSetting( 'box_shadow', 'false' );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipjck-btn-group">
                <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
                <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipjck-onoff-value" name="box_shadow" value="<?php echo $val; ?>" />
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Determines whether to add a shadow effect on the box.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

			<?php
			//Header
			$this->view( 'admin/widget/design/header' );
			//Content
			$this->view( 'admin/widget/design/content' );
			//Choice
			$this->view( 'admin/widget/design/choice' );
			//Footer
			$this->view( 'admin/widget/design/footer' );
			//Close button
			$this->view( 'admin/widget/design/close' );
			?>

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>
