<?php
/**
 * Manage action view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>
<div id="ipjck-section-action" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-edit"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Action', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the widget actions', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields ipjck-section-select">

      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-action-type">
            <?php _e( 'Action Type', IPJCK_SLUG ); ?>
          </label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <select name="action_type" id="input-action-type" class="ipjck-input ipjck-section-select-options">
            <?php
            $current = $setting->getSetting( 'action_type', 'button' );
            $types   = array(

              'social' => __( 'Social Buttons', IPJCK_SLUG ),
              'button' => __( 'Button', IPJCK_SLUG ),
              'link'   => __( 'Link', IPJCK_SLUG )
            );
            foreach( $types as $key => $label )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the widget action type.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Social Button
      $this->view( 'admin/widget/action/social' );
      //Button
      $this->view( 'admin/widget/action/button' );
      //Link
      $this->view( 'admin/widget/action/link' );
      ?>

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>
